package net.sf.gluebooster.demos.pojo.planning.blockworld;

import net.sf.gluebooster.java.booster.essentials.meta.Stringable;
import net.sf.gluebooster.java.booster.essentials.objects.BoostedObject;

/**
 * An agent currently is the owner of one hand.
 * 
 * @author CBauer
 * 
 */
public class Agent extends BoostedObject implements Stringable {

	/**
	 * The name of the hand of this agent.
	 */
	private String nameOfHand;

	/**
	 * 
	 * @param name
	 *            the name of this agent.
	 */
	public Agent(String name, String nameOfHand) {
		setName(name);
		setNameOfHand(nameOfHand);
	}

	public String getNameOfHand() {
		return nameOfHand;
	}

	public void setNameOfHand(String nameOfHand) {
		this.nameOfHand = nameOfHand;
	}

	@Override
	public String toString() {

		return super.toString() + " (" + nameOfHand + ")";
	}

	@Override
	public String toString(int level) {
		return toString();
	}

	
}
