package net.sf.gluebooster.demos.pojo.planning.blockworld;

import java.util.Hashtable;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

import net.sf.gluebooster.java.booster.basic.container.BoostedNode;
import net.sf.gluebooster.java.booster.basic.math.Operation;
import net.sf.gluebooster.java.booster.basic.math.planning.Plan;
import net.sf.gluebooster.java.booster.basic.math.planning.Planning;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;

/**
 * Calculates concrete objects to replace virtual objects.
 * 
 * @author CBauer
 * 
 */
public class BlockworldVirtualObjectInstantiator extends CallableAbstraction<Object, Pair<Hand, Hand>> {

	/**
	 * Always returns the first hand found in the blockworld.
	 */
	private Pair<Hand, Hand> instantiate(Object boostedNodeWithVirtualObject, Object hashtableWithPlan) throws Exception {
		Hashtable<?, ?> environmentWithPlan = (Hashtable) hashtableWithPlan;
		Plan<Table> plan = Planning
				.getPlanFromHashtable(environmentWithPlan);
		Table instance = plan.getWorldInstanceDescription();
		Operation<Table> operation = Operation
				.getOperation((BoostedNode) boostedNodeWithVirtualObject);
		if (!Blockworld.OPERATOR_NEW_VIRTUAL_OBJECT.equals(operation
				.getOperator())) {
			throw new IllegalStateException(
					"Expected OPERATOR_NEW_VIRTUAL_OBJECT, got "
					+ operation.getOperator());
		}
		Hand virtualHand = operation.getOperatorDetails();
		return new ImmutablePair<Hand, Hand>(virtualHand, instance.getHands()
				.iterator().next());

	}

	// /**
	// * Always returns the first hand found in the blockworld.
	// */
	// @Override
	// public Object getObjectInstance(Object boostedNodeWithVirtualObject, Name ignored, Context ignoredCtx, Hashtable<?, ?> environmentWithPlan)
	// throws Exception {
	// return instantiate(boostedNodeWithVirtualObject, environmentWithPlan);
	// }

	@Override
	protected Pair<Hand, Hand> callImpl(Object... parameters) throws Exception {
		return instantiate(parameters[0], parameters[1]);
	}


}
