package net.sf.gluebooster.demos.pojo.planning.blockworld;

import java.awt.Dimension;

/**
 * Forbidden places are places where no more blocks should be moved. There may
 * be some blocks lying there. These blocks should not be moved away. No other
 * blocks should be moved to this place.
 * 
 * @author CBauer
 *
 */
public class ForbiddenPlace extends Place<ForbiddenPlace> {


	/**
	 * Constructor from a dimension.
	 * 
	 * @param xy
	 *            the widht is x the height is y
	 */
	public ForbiddenPlace(Dimension xy) {
		super(xy);
	}


	/**
	 * 
	 * @param x
	 *            the x-coordinate of the place.
	 * @param y
	 *            the y-coordinate of the place.
	 */
	public ForbiddenPlace(int x, int y) {
		super(x, y);
	}


	public ForbiddenPlace() {

	}

	/**
	 * Constructor that copies from another place
	 * 
	 * @param place
	 *            the original
	 */
	public ForbiddenPlace(Place place) {
		super(place.getX(), place.getY());
	}

	@Override
	public String toString() {

		return "Forbidden place " + getX() + "/" + getY();
	}

}
