package net.sf.gluebooster.demos.pojo.planning.blockworld;


/**
 * Free blocks are blocks, that have no other block over them.
 * 
 * @author CBauer
 *
 */
public class FreeBlock extends Block {


	/**
	 * Constructor that copies the data from another block
	 * 
	 * @param block
	 *            the other block
	 */
	public FreeBlock(Block block) {
		super(block.getName().toString(), block.getX(), block.getY(), block
				.getType(),
				block.getOrientation(), block.getUp(), block.getOverBlocks());
	}




	@Override
	public String toString() {

		return "Free block " + getName();
	}

}
