package net.sf.gluebooster.demos.pojo.planning.blockworld;

import java.awt.Dimension;

/**
 * Free places are places where no block lies.
 * 
 * @author CBauer
 *
 */
public class FreePlace extends Place<FreePlace> {


	/**
	 * Constructor that copies from another place
	 * 
	 * @param place
	 *            the original
	 */
	public FreePlace(Place place) {
		super(place);
	}

	/**
	 * Constructor from a dimension.
	 * 
	 * @param xy
	 *            the widht is x the height is y
	 */
	public FreePlace(Dimension xy) {
		super(xy);
	}


	/**
	 * 
	 * @param x
	 *            the x-coordinate of the place.
	 * @param y
	 *            the y-coordinate of the place.
	 */
	public FreePlace(int x, int y) {
		super(x, y);
	}


	public FreePlace() {

	}


	@Override
	public String toString() {

		return "Free place " + getX() + "/" + getY();
	}

}
