package net.sf.gluebooster.demos.pojo.planning.blockworld;

import java.awt.Dimension;

/**
 * One place element of the table.
 * 
 * @author CBauer
 * 
 */
public class Place<Implementation extends Place<Implementation>> extends
		AbstractTableElement<Implementation> {

	/**
	 * 
	 * @param x
	 *            the x-coordinate of the place.
	 * @param y
	 *            the y-coordinate of the place.
	 */
	public Place(int x, int y) {
		setX(x);
		setY(y);
	}

	/**
	 * Constructor that copies from another place
	 * 
	 * @param place
	 *            the original
	 */
	public Place(Place place) {
		setX(place.getX());
		setY(place.getY());
	}

	/**
	 * Constructor from a dimension.
	 * 
	 * @param xy
	 *            the widht is x the height is y
	 */
	public Place(Dimension xy) {
		this(xy.width, xy.height);
	}

	public Place() {

	}


	@Override
	public String toString() {

		return "place " + getX() + "/" + getY();
	}

	/**
	 * TODO refactor into boostedObject, so that the names work as ids.
	 */
	@Override
	public void setName(Object name) {
		super.setName(name);
		super.setId(name);
	}

	@Override
	public int hashCode() {
		final int prime = 31;

		int result = ((getX() == null) ? 0 : getX().hashCode());
		result = prime * result + ((getY() == null) ? 0 : getY().hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (getClass() != obj.getClass())
			return false;
		AbstractTableElement other = (AbstractTableElement) obj;
		Integer x = getX();
		Integer y = getY();
		if (x == null) {
			if (other.getX() != null)
				return false;
		} else if (!x.equals(other.getX()))
			return false;
		if (y == null) {
			if (other.getY() != null)
				return false;
		} else if (!y.equals(other.getY()))
			return false;
		return true;
	}

}
