package net.sf.gluebooster.demos.pojo.planning.blockworld;

import net.sf.gluebooster.java.booster.essentials.math.Condition;
import net.sf.gluebooster.java.booster.essentials.meta.HasName;

/**
 * A table element is an element that can be placed on the table (a block) or
 * the description/condition of a part of the table.
 * 
 * @author CBauer
 * 
 * @param <Implementation>
 */
public interface TableElement<Implementation extends TableElement<Implementation>>
		extends HasName, Condition {

	/**
	 * Tests whether all information about this element is known. Example: Of a
	 * block one must know its position, type, orientation and whether the block
	 * is up or down.
	 * 
	 * @throws IllegalStateException
	 */
	public void checkThatAllStatesAreKnown() throws IllegalStateException;
}
