package net.sf.gluebooster.demos.pojo.prolog;

public abstract class AbstractProlog implements Prolog {

	int varCounter = 1;

	public static Prolog getDefaultProlog() {
		return new TuProlog();
	}

	public abstract Object TRUE();

	public abstract Object and(Object term1, Object term2) throws Exception;

	public abstract Object or(Object term1, Object term2) throws Exception;

	@Override
	public Object fact(Object compound) throws Exception {

		return rule(compound, TRUE());
	}

	@Override
	public Object addRule(Object defined, Object definition) throws Exception {
		Object result = rule(defined, definition);
		add(result);
		return result;
	}

	@Override
	public Object addFact(Object compound) throws Exception {
		Object result = fact(compound);
		add(result);
		return result;
	}


	@Override
	public Object conjunction(Object... terms) throws Exception {
		Object result = terms[0];
		for (int i = 1; i < terms.length; i++) {
			result = and(result, terms[i]);
		}
		return result;
	}

	@Override
	public Object disjunction(Object... terms) throws Exception {
		Object result = terms[0];
		for (int i = 1; i < terms.length; i++) {
			result = or(result, terms[i]);
		}
		return result;
	}

	@Override
	public Object var() throws Exception {

		return var("Var" + varCounter++);
	}

	
}
