package net.sf.gluebooster.demos.pojo.prolog;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/**
 * Facade of prolog implementations.
 * 
 * @author cbauer
 *
 */
public interface Prolog {

	/**
	 * Create a variable
	 * 
	 * @param name
	 * @return
	 * @throws Exception
	 */
	Object var(String name) throws Exception;

	/**
	 * Create a new variable
	 * 
	 * @return
	 * @throws Exception
	 */
	Object var() throws Exception;

	String getVarname(Object var) throws Exception;

	/**
	 * a constant
	 * 
	 * @param value
	 * @return
	 * @throws Exception
	 */
	Object atom(String value) throws Exception;

	String getAtomValue(Object atom) throws Exception;

	Object compound(String predicate, Object... terms) throws Exception;

	/**
	 * Reverses the compound method.
	 * 
	 * Results may look like {':-', 'Boolean@falsum@naive',true}
	 * 
	 * @param compound
	 * @return [predicate, term1, term2, ...]
	 * @throws Exception
	 */
	Object[] unCompound(Object compound) throws Exception;

	Object list(Object... elements) throws Exception;

	Object listWith(Object head, Object tailList);

	Object rule(Object defined, Object definition) throws Exception;

	Object addRule(Object defined, Object definition) throws Exception;

	Object fact(Object compound) throws Exception;

	Object addFact(Object compound) throws Exception;

	/**
	 * Equality of two objects
	 */
	Object equals(Object term1, Object term2) throws Exception;

	/**
	 * first AND second
	 */
	Object conjunction(Object... terms) throws Exception;

	/**
	 * first OR second
	 */
	Object disjunction(Object... terms) throws Exception;

	/**
	 * Add to the theory used for computations.
	 * 
	 * @param factOrRule
	 * @throws Exception
	 */
	void add(Object factOrRule) throws Exception;

	/**
	 * Gets a representation of the added objects.
	 */
	Object getAddedObjects() throws Exception;

	/**
	 * Create a String representation. Each rule is to be displayed as ':-'(defined,definition)
	 * 
	 * @return
	 * @throws Exception
	 */
	String getAddedObjectsAsRules() throws Exception;

	void humanReadable(Object object, StringBuilder result) throws Exception;

	/**
	 * States that the initialization with facts and rules has ended.
	 * 
	 * @throws Exception
	 */
	void initEnd() throws Exception;

	String getInitContent() throws Exception;

	/**
	 * Computes one solution
	 * 
	 * @param compoundWithVariables
	 * @param interestingVariables
	 * @return null if no solution exists; map variable names to their value (compound)
	 * @throws Exception
	 */
	Map<String, Object> getFirstSolution(Object compoundWithVariables, Object... interestingVariables) throws Exception;

	Collection<Map<String, Object>> getAllSolutions(Object compoundWithVariables, Object... interestingVariables) throws Exception;

	Iterator<Map<String, Object>> getSolutionIterator(final Object compoundWithVariables, final Object... interestingVariables) throws Exception;

}
