package net.sf.gluebooster.demos.pojo.wiki;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.apache.commons.lang3.tuple.Pair;

import net.sf.gluebooster.java.booster.basic.gui.swing.SwingBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.IoBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.TextBoostUtils;

/**
 * {@Feature}Application to get the authors of an wikipedia article. They are needed for citations and references.{@FeatureEnd} This application is currently
 * only usable in the german locale. TODO internationalize the application including the keywords that are used for parsing.
 * 
 * @author CBauer
 *
 */
public class WikiAuthors implements ActionListener {

	/**
	 * The name of the wiki page.
	 */
	private TextField pagename = new TextField(50);

	/**
	 * The language of the wiki page.
	 */
	private TextField language = new TextField("zh");
	
	/**
	 * The wiki version (wikipedia, wikibooks, etc.)
	 */
	private TextField wiki = new TextField("wikipedia");

	/**
	 * The code of the wiki version (w = wikipedia)
	 */
	private TextField wikicode = new TextField("w");
	
	/**
	 * A click on this button creates the url of the xtools.
	 */
	private Button send = new Button("Send");
	
	/**
	 * Contains the link to the xTools.
	 */
	private TextField xToolsLink = new TextField(100);
	/**
	 * The textarea containing the wiki markup that is to be modified and the
	 * modification result
	 */
	private TextArea result = new TextArea(50, 200);

	/**
	 * A click on this button modifies the result of the xtools and corrects
	 * errors.
	 */
	private Button extract = new Button("Nach Export as wikitable");

	/**
	 * The frame of this application.
	 */
	private JFrame frame;

	public WikiAuthors() {
		frame = new SwingBoostUtils().createFrame("Wiki-Authors", 1000, 600, true, new BorderLayout());

		ArrayList<Component> panels = new ArrayList<Component>();

		pagename.setText("meinArtikel");

		panels.add(SwingBoostUtils.createPanel("Seitenname:", pagename));
		panels.add(SwingBoostUtils.createPanel("Sprache:", language));
		panels.add(SwingBoostUtils.createPanel("Wiki:", wiki, "Projektcode", wikicode));
		panels.add(SwingBoostUtils.createPanel(send));
		send.addActionListener(this);

		xToolsLink.setText("X! Tools link");
		panels.add(SwingBoostUtils.createPanel("X!'s Tools", xToolsLink));

		extract.addActionListener(this);
		panels.add(SwingBoostUtils.createPanel(extract));

		panels.add(SwingBoostUtils.createPanel("Ergebnis:", result));

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridBagLayout());
		// mainPanel.setLayout(new GridLayout(panels.length, 1));
		int y = 0;
		for (Component panel : panels) {
			GridBagConstraints constraints = new GridBagConstraints();
			constraints.gridy = y++;
			mainPanel.add(panel, constraints);
		}

		frame.getContentPane().add(new JScrollPane(mainPanel), BorderLayout.CENTER);

		frame.setVisible(true);

	}

	/**
	 * Starts the application
	 * @param ignored the parameters are ignored
	 */
	public static void main(String[] ignored) {
		new WikiAuthors();
	}

	/**
	 * Simulates the click on the send-button.
	 */
	public void clickSend() {
		actionPerformed(new ActionEvent(send, ActionEvent.ACTION_PERFORMED, null));
	}

	/**
	 * Simulates the click after the export.
	 * 
	 * @param xtoolstext
	 *            the text of the xtools containing the editors info
	 */
	public void clickAfterExport(String xtoolstext) {
		IoBoostUtils.setClipboard(xtoolstext);
		actionPerformed(new ActionEvent(extract, ActionEvent.ACTION_PERFORMED, null));
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		try {
			if (send.equals(e.getSource())) {
				xToolsLink
						.setText("https://tools.wmflabs.org/xtools-articleinfo/?article="
								+ pagename.getText()
								+ "&project="
								+ language.getText()
								+ "."
								+ wiki.getText()
								+ ".org");
			} else if (extract.equals(e.getSource())) {
				String data = IoBoostUtils.getClipboardString();
				// data is something like the following
				// * wiki-title-of-page
				// * zh.wikipedia.org
				// * Gesamtzahl der Versionen: 33
				// * Anzahl Autoren: 18
				// * 2016-01-21 12:48:37
				//
				// <sup>1</sup> Bearbeitungen<br />
				// <sup>2</sup> Durchschnittliche Zeit zwischen den
				// Bearbeitungen
				// {| class="wikitable sortable"
				// !Benutzername
				// !#<sup>1</sup>
				// !Kleine Bearb.
				// !%
				// !Erste Bearbeitung
				// !Aktuellste Bearbeitung
				// !atbe<sup>2</sup>
				// !HinzugefÃ¼gt (Bytes)
				// |-
				// | [[User:Pbdragonwang|Pbdragonwang]] || 6 || 2 || 33,3 ||
				// 2010-05-11, 17:37 || 2010-05-13, 11:26 || 0,3 || 8.068
				// ...
				// |-
				// | [[User:118.167.197.67|118.167.197.67]] || 1 || 0 || 0 ||
				// 2010-09-18, 09:23 || 2010-09-18, 09:23 || 0 || 0
				// |}
				


				StringBuilder prefix = new StringBuilder("= Autorenliste =\r\n");
				prefix.append("{{Autoren XTools\r\n");
				prefix.append("|Sprache = ").append(language.getText())
						.append("\r\n");
				prefix.append("|Projekt = ").append(wiki.getText())
						.append("\r\n");
				prefix.append("|Projektcode = ").append(wikicode.getText())
						.append("\r\n");
				prefix.append("|Seite = ").append(pagename.getText())
						.append("\r\n");
				Pair<String, Integer> numberOfVersions = TextBoostUtils.findPattern(
						data,
						"Gesamtzahl der Versionen:(.*)", 1);
				prefix.append("|Anzahl Versionen = ")
						.append(numberOfVersions.getLeft())
						.append("\r\n");
				Pair<String, Integer> numberOfAuthors = TextBoostUtils.findPattern(
						data,
						"Anzahl Autoren:(.*)", 1);
				int lineEndIndex = data.indexOf("\n",
						numberOfAuthors.getRight());
				prefix.append("|Anzahl Autoren = ")
						.append(numberOfAuthors.getLeft())
						.append("\r\n");

				int nextLineEndIndex = data.indexOf("\n", lineEndIndex + 1);
				String dateTime = data.substring(lineEndIndex + 1,
 nextLineEndIndex)
						.replace("*", "").trim();
				SimpleDateFormat englishDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); 
				SimpleDateFormat germanDateFormatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss"); 
				prefix.append("|Datum und Zeit = ")
						.append(germanDateFormatter.format(englishDateFormatter
								.parse(dateTime)))
						.append("\r\n");
				prefix.append("|Typ = Copy").append("\r\n");
				prefix.append("|Liste = lang").append("\r\n");
				prefix.append("}}").append("\r\n");
				prefix.append("{| class=\"wikitable sortable\"").append("\r\n");
				prefix.append("!Benutzername \r\n!colspan=\"3\" | Bearbeitungen <sup>1</sup> \r\n!Erste Bearbeitung \r\n!Aktuellste Bearbeitung \r\n!atbe<sup>2</sup> \r\n!HinzugefÃ¼gt (Bytes)	\r\n");

				int rowStart = data.indexOf("|-");
				data = data.substring(rowStart);
				data = data.replace("[[User:", "[[" + wikicode.getText() + ":"
						+ language.getText() + ":User:");

				// Matcher matcher = Pattern.compile(
				// "User\\:(\\d+\\.\\d+\\.\\d+\\.\\d+)\\|").matcher(data);
				// while (matcher.find()) {
				// System.out.println(matcher.group());
				// }
				data = data.replaceAll("User\\:(\\d+\\.\\d+\\.\\d+\\.\\d+)\\|",
						"Special:Contributions/$1|");

				data = prefix.toString()
						+ data
						+ "\r\n{{Autoren XTools Ende|Importeur=~~~}}\r\n\r\n= Diskussionen =\r\n";
				
				result.setText(data);
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}

	}

	public void setPagename(String newName) {
		pagename.setText(newName);
	}

	public void setLanguage(String newLanguage) {
		language.setText(newLanguage);
	}

	public void setWiki(String wikiname) {
		wiki.setText(wikiname);
	}

	public void setWikicode(String newCode) {
		wikicode.setText(newCode);
	}

	public JFrame getFrame() {
		return frame;
	}

	public void setXToolsLink(String newLink) {
		xToolsLink.setText(newLink);
	}
}
