package net.sf.gluebooster.demos.pojo.yoga;

import net.sf.gluebooster.demos.pojo.learning.Excercise;
import net.sf.gluebooster.demos.pojo.learning.ExcerciseGroupConfiguration;
import net.sf.gluebooster.demos.pojo.learning.KnowledgeLevel;

/**
 * A yoga application to create excercises. 
 * @author cbauer
 *
 */
public class YogaApp {

	/**
	 * The configuration of the appliation
	 */
	private ExcerciseGroupConfiguration configuration;

	public YogaApp() {
		configuration = new ExcerciseGroupConfiguration();
		configuration.setKnowledgeLevel(KnowledgeLevel.INTERMEDIATE);
		configuration.setStyle(YogaStyleFactory.getDefaultStyles().get(
				YogaStyleFactory.YOGA_VIDYA));

	}

	/**
	 * Creates a default yoga class.
	 */
	public void createYogaClass() {
		configuration.setExcerciseTheme(YogaExcercises.DEFAULT_YOGA_CLASS);
		Excercise result = configuration.createExcercise();
		System.out.println(result);

	}



	/**
	 * Creates a default yoga class
	 * @param ignored the parameters are ignored.
	 */
	public static void main(String[] ignored) {
		new YogaApp().createYogaClass();
	}
}
