package net.sf.gluebooster.demos.pojo.yoga;

import java.util.HashMap;
import java.util.Map;

import net.sf.gluebooster.demos.pojo.learning.ExcerciseGroup;
/**
 * The different styles of yoga like yoga vidya, ashtanga, etc. 
 * @author cbauer
 *
 */
public class YogaStyleFactory {

	public static final String YOGA_VIDYA = "Yoga Vidya";

	/**
	 * Creates the default yoga vidya excercises.
	 * @return the created style.
	 */
	public static ExcerciseGroup createYogaVidyaStyle() {

		ExcerciseGroup result = new ExcerciseGroup(YOGA_VIDYA);

		ExcerciseGroup initialRelaxation = new ExcerciseGroup(
				"Initial Relaxation", YogaExcercises.RELAXATION);

		ExcerciseGroup pranayama = new ExcerciseGroup(YogaExcercises.PRANAYAMA,
				YogaExcercises.PRANAYAMA);

		ExcerciseGroup asanas = new ExcerciseGroup(YogaExcercises.ASANAS,
				YogaExcercises.ASANAS);

		ExcerciseGroup finalRelaxation = new ExcerciseGroup("Final Relaxation",
				YogaExcercises.RELAXATION);

		ExcerciseGroup defaultYogaClass = new ExcerciseGroup(
				YogaExcercises.DEFAULT_YOGA_CLASS,
				YogaExcercises.DEFAULT_YOGA_CLASS);
		defaultYogaClass.addExcercise(initialRelaxation);
		defaultYogaClass.addExcercise(pranayama);
		defaultYogaClass.addExcercise(asanas);
		defaultYogaClass.addExcercise(finalRelaxation);


		result.addExcercise(defaultYogaClass);

		return result;
	}

	/**
	 * Creates default excercises for different styles.
	 * @return name -> style
	 */
	public static Map<String, ExcerciseGroup> getDefaultStyles() {
		HashMap<String, ExcerciseGroup> result = new HashMap<String, ExcerciseGroup>();

		ExcerciseGroup style = createYogaVidyaStyle();
		result.put(style.getName(), style);

		return result;
	}

}
