package net.sf.gluebooster.demos.pojo.flashcards;

import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Map;

import javax.swing.JFrame;

import org.junit.Test;

import net.sf.gluebooster.java.booster.basic.mvc.AppDisplayBySwingBorderLayout;
import net.sf.gluebooster.java.booster.essentials.TestRoot;
import net.sf.gluebooster.java.booster.essentials.meta.Example;
import net.sf.gluebooster.java.booster.essentials.utils.Constants;
import net.sf.gluebooster.java.booster.essentials.utils.GuiBoostUtils;

public class FlashcardDemoTest extends TestRoot {

	/**
	 * An example to learn with flashcards.
	 * 
	 * 
	 * @throws Exception
	 */
	@Test
	@Example(clasz = FlashcardDemo.class, method = "startSimpleSwingDemo")
	public void flashcardDemo() throws Exception {
		File directory = createTempDirectory("images");

		// [gb:useInDocumentation]
		AppDisplayBySwingBorderLayout layout = FlashcardDemo.startSimpleSwingDemo(null);
		// no flashcard is displayed yet, the number of flashcards in the first compartmant is displayed below the menu
		Map displayModel = layout.getModelOfBackendLayer();

		JFrame frame = layout.getFrame();
		FlashcardsAppView view = (FlashcardsAppView) layout.getBackend();
		MouseEvent leftClick = new MouseEvent(frame, MouseEvent.MOUSE_CLICKED, System.currentTimeMillis(), MouseEvent.BUTTON1_MASK, 1, 1, 1, false,
				MouseEvent.BUTTON1);
		MouseEvent rightClick = new MouseEvent(frame, MouseEvent.MOUSE_CLICKED, System.currentTimeMillis(), MouseEvent.BUTTON2_MASK, 1, 1, 1, false,
				MouseEvent.BUTTON2);
		GuiBoostUtils.createScreenshot(directory, "step1", frame, false, true);
		// </pre><img src="images/step1.png"/><pre>

		view.call(Constants.MOUSE_CLICKED, leftClick, displayModel);
		// the front side is displayed
		GuiBoostUtils.createScreenshot(directory, "step2", frame, false, true);
		// </pre><img src="images/step2.png"/><pre>

		view.call(Constants.MOUSE_CLICKED, leftClick, displayModel);
		// the back side is displayed
		GuiBoostUtils.createScreenshot(directory, "step3", frame, false, true);
		// </pre><img src="images/step3.png"/><pre>

		// mark the card as known
		view.call(Constants.MOUSE_CLICKED, leftClick, displayModel);

		// the next front side is displayed and the compartments have changed: a new compartment with 1 card is created (at the right).
		GuiBoostUtils.createScreenshot(directory, "step4", frame, false, true);
		// </pre><img src="images/step4.png"/><pre>

		view.call(Constants.MOUSE_CLICKED, leftClick, displayModel);
		// the back side is displayed
		GuiBoostUtils.createScreenshot(directory, "step5", frame, false, true);
		// </pre><img src="images/step5.png"/><pre>

		// mark the card as not known. If the card has been known prviously the compartments change: the first compartment has one more card and the compartment
		// of the current card has one card less.
		view.call(Constants.MOUSE_CLICKED, leftClick, displayModel);

		// the next front side is displayed
		GuiBoostUtils.createScreenshot(directory, "step6", frame, true, true);
		// </pre><img src="images/step6.png"/><pre>
		// [/gb:useInDocumentation]

		copyExampleResultFiles(directory);
		// frame.setVisible(false);
		// frame.dispose();
	}
}
