package net.sf.gluebooster.demos.pojo.flashcards;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import org.junit.Test;

import net.sf.gluebooster.demos.pojo.languages.VocabularyEntry;
import net.sf.gluebooster.java.booster.basic.mvc.AppDefinition;
import net.sf.gluebooster.java.booster.essentials.TestRoot;
import net.sf.gluebooster.java.booster.essentials.utils.ContainerBoostUtils;

public class FlashcardsTest extends TestRoot {

	@SuppressWarnings("unchecked")
	@Test
	// @Example(clasz = FlashcardApplication.class)
	public void simpleFlashcardExample() throws Exception {
		
		List/* <VocabularyEntry> */cards = Arrays.asList(
				new VocabularyEntry("〇", "ling2", "zero"),
				new VocabularyEntry("一", "yi1", "one"),
				new VocabularyEntry("下", "xia", "below")				
				);
		Flashcards<Object> flashcards = new Flashcards<Object>();
		flashcards.setCardsAtLevel0(cards);
		flashcards.setNames(ContainerBoostUtils.createMap(0, "Chinese", 1,
				"Pinyin", 2, "English"));
		flashcards.setFrontSideIndices(new int[] { 0 });
		flashcards.setBackSideIndices(new int[] { 1, 2 });

		HashMap<Object, Object> model = new HashMap<Object, Object>();
		model.put(FlashcardDemo.FIELD_ALL_FLASHCARDS, flashcards);
		model.put(AppDefinition.FIELD_TITLE, "Chinese Vocabulary");

		FlashcardDemo.startSimpleSwingDemo(model);

		// FlashcardsAppView view = new FlashcardsAppView();
		// FlashcardsAppDisplaySwing display = new FlashcardsAppDisplaySwing(view);
		// view.setDisplayModel(display.getDisplayModel());
		// FlashcardsAppController controller = new FlashcardsAppController(model);
		// view.setController(controller);
		// view.executeCommand(AppDefinition.COMMAND_START, null);
	}

}
