package net.sf.gluebooster.demos.pojo.languages.chinese;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.junit.Assert;
import org.junit.Test;

public class CcCedictEntryTest {

	@Test
	public void testParseEntry() {

		ChineseVocabularyEntry entry = CeDictParser
				.parseEntry("阿貝 阿贝 [a1 bei4] /Abbe / (1840 - 1905)");

		Assert.assertEquals("阿貝", entry.getTraditional());
		Assert.assertEquals("阿贝", entry.getSimplified());
		List<Pair<String, List<String>>> pinyinTranslationList = entry
				.getPinyinTranslations();
		Assert.assertNotNull(pinyinTranslationList);
		Assert.assertEquals(1, pinyinTranslationList.size());
		Pair<String, List<String>> pinyinTranslations = pinyinTranslationList
				.get(0);
		Assert.assertEquals("a1 bei4", pinyinTranslations.getLeft());
		Assert.assertEquals(2, pinyinTranslations.getRight().size());
		Assert.assertEquals("Abbe",
				pinyinTranslations.getRight().get(0));
		Assert.assertEquals("(1840 - 1905)",
				pinyinTranslations.getRight().get(1));

		entry = CeDictParser
				.parseEntry("瓦 瓦 [wa4] / decken; Bsp.: 瓦刀 瓦刀 -- Kittmesser; Bsp.: 瓦瓦 瓦瓦 -- ein Dach mit Ziegeln decken / wa3: Dachziegel (S)/ Ziegel/ xyz4: test");
		pinyinTranslationList = entry.getPinyinTranslations();
		Assert.assertEquals(3, pinyinTranslationList.size());

		entry = CeDictParser
				.parseEntry("刀 刀 [dao1] / Messer Bsp.: 一刀紙 一刀纸 Bsp.: 一刀纸 一刀纸   /");
		pinyinTranslationList = entry.getPinyinTranslations();
		pinyinTranslations = pinyinTranslationList.get(0);
		Assert.assertEquals("Messer Bsp.: (一刀紙) 一刀纸 Bsp.: 一刀纸",
				pinyinTranslations.getRight().get(0));
	}

	@Test
	public void testParseDictionary() throws Exception {
		String text = "#my dictionary\n\n阿貝 阿贝 [a1 bei4] /Abbe \n阿貝 阿贝 [a1 bei5] / (1840 - 1905)\n瓦 瓦 [wa4] / decken; \n\n";
		Collection<ChineseVocabularyEntry> dictionary = CeDictParser
				.parseDictionary(text, false);
		Assert.assertEquals(2, dictionary.size());
	}

}
