package net.sf.gluebooster.demos.pojo.languages.chinese;

import java.io.File;
import java.util.Map;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import org.junit.Ignore;
import org.junit.Test;

import junit.framework.Assert;
import net.sf.gluebooster.java.booster.basic.mvc.AppDefinition;
import net.sf.gluebooster.java.booster.basic.mvc.AppDisplayBySwingBorderLayout;
import net.sf.gluebooster.java.booster.basic.mvc.Layer;
import net.sf.gluebooster.java.booster.essentials.TestRoot;
import net.sf.gluebooster.java.booster.essentials.meta.Example;
import net.sf.gluebooster.java.booster.essentials.utils.GuiBoostUtils;

public class ChineseDemoTest extends TestRoot /* implements CommandHandler<String, Object, Object> */ {

	private static final String CLOSE_CONFIGURATION = "close configuration";

	private AppDisplayBySwingBorderLayout demoLayout;

	public ChineseDemoTest() {
	}


	/**
	 * An example of the features of the chinese app.
	 * 
	 * 
	 * @throws Exception
	 */
	@Test
	@Ignore("Test fails; load configuratio not yet implemented")
	@Example(clasz = ChineseDemo.class)
	public void chineseDemo() throws Exception {
		final File directory = createTempDirectory("images");
		File tempDirectory = createTempDirectory("temp");

		// [gb:useInDocumentation]
		// Initialization
		AppDisplayBySwingBorderLayout layout = ChineseDemo.startSampleApp();
		// </pre>Initial screen: <br/><img src="images/step1.png"/><pre>
		// [/gb:useInDocumentation]
		Map displayModel = layout.getModelOfBackendLayer();
		final JFrame frame = layout.getFrame();
		GuiBoostUtils.createScreenshot(directory, "step1", frame, false, true);
		final Layer view = layout.getBackend();

		ChineseDemoTest commandHandler = new ChineseDemoTest();
		commandHandler.demoLayout = layout;

		GuiBoostUtils.createScreenshot(directory, "step1a", frame, false, commandHandler, AppDefinition.COMMAND_EDIT_CONFIGURATION, CLOSE_CONFIGURATION);
		// [gb:useInDocumentation]
		// </pre>The original empty configuration <br/><img src="images/step1a.png"/><pre>
		// [/gb:useInDocumentation]

		StringBuilder dictionarytext = new StringBuilder();
		dictionarytext.append("麼 么 [me5] /(Fragepartikel der Umgangssprache) (u.E.)/\r\n");
		dictionarytext.append(
				"麻 麻 [ma2] /Anästhesie (u.E.) (S, Med)/beschäftigen, ärgern (u.E.) (S)/Hanf (u.E.) (S)/prickeln, taub werden (u.E.) (V)/betäubt, empfindungslos (u.E.) (Adj)/uneben, rauh, pockenartig (u.E.) (Adj)/Radikal Nr. 200 = Hanf, Flachs, Jute, Sesam (u.E.) (S)/\r\n");
		dictionarytext.append(
				"廣 广 [guang3] /breit, umfangreich, weit reichend (u.E.)/weit (u.E.)/Radikal Nr. 53 = Schrägdach, Schutz, Unterschlupf, Unterbringung (u.E.) (S)/\r\n");
		dictionarytext.append("林 林 [lin2] /Wald (u.E.) (S)/Lin (u.E.) (Eig, Fam)/\r\n");
		dictionarytext.append(
				"木 木 [mu4] /Baum (S)/Holz (S)/Nutzholz (S)/hölzern, aus Holz gemacht (Adj)/Radikal Nr. 75 = Baum, Holz/erstarrt, empfindungslos, taub (Adj)/\r\n");
		dictionarytext
				.append("么 幺 [yao1] /eins ( Aussprache der Ziffer 1 ) (u.E.) (Adj)/jünste (u.E.) (Adj)/klein, fein, winzig, unbedeutend (u.E.) (Adj)/\r\n");
		dictionarytext.append(
				"幺 幺 [yao1] /eins (Aussprache der Ziffer 1) (u.E.)/Radikal Nr. 52 = jung, gering, klein, unreif, jüngst; früher auch: zart, fein (u.E.)/\r\n");

		File dictionaryFile = writeTextfileAndCreateScreenshot(new File(tempDirectory, "dictionary.txt"), dictionarytext, 900, 480, directory, "step2");
		// [gb:useInDocumentation]
		// </pre>A simple small dictionary <br/><img src="images/step2.png"/><pre>
		// [/gb:useInDocumentation]

		StringBuilder characterComponents = new StringBuilder();
		characterComponents.append("<pre>\r\n");
		characterComponents.append("	麼	14	吕	麻	11		幺	3		ICVI	麻\r\n");
		characterComponents.append("	麻	11	吕	广	3		林	8		IJCC	*\r\n");
		characterComponents.append("	林	8	吅	木	4		*	4		DD	木\r\n");
		characterComponents.append("</pre>\r\n");
		characterComponents.append("\r\n");

		File componentsFile = writeTextfileAndCreateScreenshot(new File(tempDirectory, "components.txt"), characterComponents, 1024, 480, directory, "step3");
		// [gb:useInDocumentation]
		// </pre>A simple small components files <br/><img src="images/step3.png"/><pre>
		// [/gb:useInDocumentation]

		File defaultResult = new File(tempDirectory, "result.txt");

		Map<Object, Object> controllerModel = view.getModelOfBackendLayer();// .executeCommand(AppDefinition.COMMAND_GET_MODEL, null,
		// view.getController().getModel());
		String componentsFilePath = componentsFile.getCanonicalPath();
		String dictionaryFilePath = dictionaryFile.getCanonicalPath();
		String resultFilePath = defaultResult.getCanonicalPath();

		displayModel.put(ChineseDemo.CONFIGURATION_FIELD_CHARACTER_COMPONENTS_FILE, componentsFilePath);
		displayModel.put(ChineseDemo.CONFIGURATION_FIELD_CHINESE_LANGUAGE1_FILE, dictionaryFilePath);
		displayModel.put(ChineseDemo.CONFIGURATION_FIELD_DEFAULT_RESULT_FILE, resultFilePath);

		GuiBoostUtils.createScreenshot(directory, "step4", frame, false, commandHandler, AppDefinition.COMMAND_EDIT_CONFIGURATION, CLOSE_CONFIGURATION);

		// Assert.assertEquals(componentsFilePath, controllerModel.get(ChineseDemo.CONFIGURATION_FIELD_CHARACTER_COMPONENTS_FILE));
		// Assert.assertEquals(dictionaryFilePath, controllerModel.get(ChineseDemo.CONFIGURATION_FIELD_CHINESE_LANGUAGE1_FILE));
		// Assert.assertEquals(resultFilePath, controllerModel.get(ChineseDemo.CONFIGURATION_FIELD_DEFAULT_RESULT_FILE));
		// [gb:useInDocumentation]
		// </pre>The configuration with the given files <br/><img src="images/step4.png"/><pre>
		// [/gb:useInDocumentation]

		displayModel.put(ChineseDemo.FIELD_ORIGINAL_TEXT, "麼廣木木木木木木木木木木木木木木");
		GuiBoostUtils.createScreenshot(directory, "step5", frame, false, true);
		// [gb:useInDocumentation]
		// </pre>Insert some traditional characters <br/><img src="images/step5.png"/><pre>
		// [/gb:useInDocumentation]

		// JOptionPane.showConfirmDialog(null, "before calling");
		view.call(ChineseDemo.COMMAND_CHANGE_TRADITIONAL_TO_SIMPLIFIED, null, displayModel);
		GuiBoostUtils.createScreenshot(directory, "step6", frame, false, true);
		Object transformed = displayModel.get(ChineseDemo.FIELD_TRANSFORMED_TEXT);
		String expected = "么广木木木木木木木木木木木木木木";
		if (!expected.equals(transformed)) {
			JOptionPane.showConfirmDialog(null, "comparing '" + expected + "' with '" + transformed + "'");
			Assert.fail("expeced: " + expected + " got: " + transformed);
		}

		// [gb:useInDocumentation]
		// </pre>Click the button the convert from traditional to simplified characters and you see the conversion <br/><img src="images/step6.png"/><pre>
		// [/gb:useInDocumentation]

		view.call(ChineseDemo.COMMAND_CREATE_VOCABULARY, null, displayModel);
		GuiBoostUtils.createScreenshot(directory, "step7", frame, false, true);
		transformed = displayModel.get(ChineseDemo.FIELD_TRANSFORMED_TEXT);
		Assert.assertTrue(transformed.toString().startsWith("广"));
		Assert.assertTrue(transformed.toString().contains("麼廣木木木木木木木木木木木木木木	null	null"));
		// [gb:useInDocumentation]
		// </pre>Click the button to create the vocabulary of the text <br/><img src="images/step7.png"/><pre>
		// [/gb:useInDocumentation]

		view.call(ChineseDemo.COMMAND_EXTRACT_CHARACTERS, null, displayModel);
		GuiBoostUtils.createScreenshot(directory, "step8", frame, false, true);
		transformed = displayModel.get(ChineseDemo.FIELD_TRANSFORMED_TEXT);
		Assert.assertEquals("木麼廣", transformed);
		// [gb:useInDocumentation]
		// </pre>Click the button to extract the vocabulary of the text <br/><img src="images/step8.png"/><pre>
		// [/gb:useInDocumentation]

		displayModel.put(ChineseDemo.FIELD_ORIGINAL_TEXT, "麼\r\n廣\r\n木");
		displayModel.put(ChineseDemo.FIELD_TRANSFORMED_TEXT, "麼廣\r\n麼木\r\n木木");
		GuiBoostUtils.createScreenshot(directory, "step9", frame, false, true);
		// [gb:useInDocumentation]
		// </pre>Insert the vocabulary into the left textarea, the text to be sorted into the vocabulary in the right textarea. <br/><img
		// src="images/step9.png"/><pre>
		// [/gb:useInDocumentation]

		view.call(ChineseDemo.COMMAND_SORT_TEXT, null, displayModel);
		GuiBoostUtils.createScreenshot(directory, "step10", frame, true, true);
		transformed = displayModel.get(ChineseDemo.FIELD_TRANSFORMED_TEXT);
		Assert.assertTrue(transformed.toString().startsWith("麼"));
		Assert.assertTrue(transformed.toString().contains("木木"));

		// [gb:useInDocumentation]
		// </pre>Click the button sort the right text into the vocabulary <br/><img src="images/step10.png"/><pre>
		// [/gb:useInDocumentation]

		copyExampleResultFiles(directory);
		frame.setVisible(false);
		// frame.dispose();
	}

	// @Override
	// public Object call(String commandName, Object parameter) throws Exception {
	// return callImpl(commandName, parameter);
	// }

	@Override
	protected Object callImpl(Object... commandAndParameter) throws Exception {
		String commandName = (String) commandAndParameter[0];
		Object parameter = commandAndParameter[1];

		Layer view = demoLayout.getBackend();

		Map displayModel = demoLayout.getModelOfBackendLayer();

		switch (commandName) {
		case CLOSE_CONFIGURATION:
			demoLayout.call(AppDefinition.COMMAND_EDITED_CONFIGURATION, null, displayModel);
			displayModel.put(AppDefinition.DIALOG_DISPLAY_CONFIGURATION, Boolean.FALSE);
			break;
		case AppDefinition.COMMAND_EDIT_CONFIGURATION:
			demoLayout.call(AppDefinition.COMMAND_EDIT_CONFIGURATION, null, displayModel);
			break;
		}

		return null;
	}

}
