package net.sf.gluebooster.demos.pojo.languages.chinese;

import java.io.StringReader;
import java.io.StringWriter;

import org.junit.Ignore;
import org.junit.Test;

import junit.framework.Assert;
import net.sf.gluebooster.java.booster.essentials.TestRoot;
import net.sf.gluebooster.java.booster.essentials.utils.TextBoostUtils;

public class TatoebaAnalyzerTest extends TestRoot {

	@Test
	public void testExtractChineseSentences() throws Exception {

		StringReader sentences_detailed_csv = new StringReader("" + "1\tcmn\t我們試試看！\tsysko\t\\N\t2010-03-14 19:46:23\r\n"
				+ "2\tcmn\t我该去睡觉了。\tfucongcong\t\\N\t2010-01-01 15:23:53\r\n" + "3\tcmn\t你在干什麼啊？\tsysko\t\\N\t2010-06-30 11:54:11\r\n"
				+ "4\tcmn\t這是什麼啊？\tMartha\t2008-09-08 09:20:59\t2011-02-27 12:01:04\r\n" + "5\tcmn\t今天是６月１８号，也是Muiriel的生日！\tZifre\t\\N\t2011-08-17 19:03:02\r\n"
				+ "6\tcmn\t生日快乐，Muiriel！\tsysko\t\\N\t2012-08-07 11:27:47\r\n" + "7\tdeu\tSatz 1\tdsysko\t\\N\t2010-03-14 19:46:23\r\n"
				+ "8\tdeu\tSatz 2\tdfucongcong\t\\N\t2010-01-01 15:23:53\r\n" + "9\tdeu\tSatz 3\tdsysko\t\\N\t2010-06-30 11:54:11\r\n"
				+ "10\tdeu\tSatz 4\tdMartha\t2008-09-08 09:20:59\t2011-02-27 12:01:04\r\n" + "11\tdeu\tSatz 5\tdZifre\t\\N\t2011-08-17 19:03:02\r\n"
				+ "12\tdeu\tSatz 6\tdsysko\t\\N\t2012-08-07 11:27:47\r\n" + "13\txxx\tSatz 6\txsysko\t\\N\t2012-08-07 11:27:47\r\n");

		StringReader links_csv = new StringReader("" + "1\t7\r\n" + "2\t8\r\n" + "3\t9\r\n" + "4\t10\r\n" + "5\t11\r\n" + "6\t13\r\n" + "13\t12\r\n");

		StringWriter result = new StringWriter();

		new TatoebaAnalyzer().extractChineseSentences(sentences_detailed_csv, links_csv, result);

		String text = result.toString();

		Assert.assertNotNull(TextBoostUtils.find(text, "我們試.*Satz 1", true));
		Assert.assertNotNull(TextBoostUtils.find(text, "我该去.*Satz 2", true));
		Assert.assertNotNull(TextBoostUtils.find(text, "生日快.*Satz 6", true));

	}
}
