package net.sf.gluebooster.demos.pojo.languages.chinese;

import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.junit.Assert;
import org.junit.Test;

import net.sf.gluebooster.java.booster.essentials.utils.IoBoostUtils;

public class VokabeltexteChinesischHelperTest {

	@Test
	public void testAll() throws Exception {
		Reader reader = IoBoostUtils.getUtf8Reader(VokabeltexteChinesischHelperTest.class.getResourceAsStream("handedict.sample.utf8"));
		VokabeltexteChinesischHelper helper = new VokabeltexteChinesischHelper(reader, false, false);
		
		StringWriter result = new StringWriter();

		String demotext0 = "== Zeichen ==\r\n" + "\r\n" + "{| class=\"wikitable\"\r\n" + "	}\r\n" + "}\r\n" + "\r\n" + "	|-\r\n";
		String demotext1 = "	| {{:Vokabeltexte_Chinesisch/ Vorlage:Chinesisch |萬念俱灰}} ||  ||([[wikt:en:萬念俱灰|Wiktionary en]])\r\n" + "	|-\r\n"
				+ "	| {{:Vokabeltexte_Chinesisch/ Vorlage:Chinesisch |一下千萬万}} || already pinyin  ||([[wikt:en:一念之差|Wiktionary en]])\r\n" + "	|-\r\n"
				+ "	| {{:Vokabeltexte_Chinesisch/ Vorlage:Chinesisch |一下千萬万}} ||  ||([[wikt:en:一念之差|Wiktionary en]])\r\n" + "	|-\r\n"
				+ "	| {{:Vokabeltexte_Chinesisch/ Vorlage:Chinesisch |我会想念你的}} || ||Ich werde dich vermissen\r\n" + "\r\n";
		String demotext2 = "some more text\r\n at the end.";
		
		String demotext = demotext0 + demotext1 + "  " + demotext2;

		helper.modify(new StringReader(demotext), result);
		String text = result.toString();
		Assert.assertFalse(text.isEmpty());
		Assert.assertTrue(text.startsWith(demotext0));
		Assert.assertTrue(text.endsWith(demotext2));
		// asserts missing

		result = new StringWriter();
		Reader originalReader = IoBoostUtils.getUtf8Reader(VokabeltexteChinesischHelperTest.class.getResourceAsStream("vokabeltexte.sample.utf8"));
		helper.modify(originalReader, result);
		text = result.toString();
		Assert.assertFalse(text.isEmpty());
		// asserts missing
	}

	@Test
	public void testGetSubdictionary() throws Exception {
		Reader reader = IoBoostUtils.getUtf8Reader(VokabeltexteChinesischHelperTest.class.getResourceAsStream("handedict.sample.utf8"));
		VokabeltexteChinesischHelper helper = new VokabeltexteChinesischHelper(reader, false, false);
		List<String> chineseCharacters = Arrays.asList("下", "一一对应", "錒");
		List<Pair<String, ChineseVocabularyEntry>> result = helper.getSubdictionary(chineseCharacters);
		Assert.assertEquals(3, result.size());
	}

	public static void main(String[] ignored) throws Exception {
		Reader reader = new FileReader("D:/temp/handedict.erweitert.utf8.txt");
		VokabeltexteChinesischHelper helper = new VokabeltexteChinesischHelper(reader, false, true);

		ArrayList<String> vocabulary = new ArrayList<String>();
		LineNumberReader reader2 = new LineNumberReader(new FileReader("D:/temp/vokabelreihe3.zeichen.utf8.txt"));
		String line = reader2.readLine();
		while (line != null) {
			line = line.trim();
			vocabulary.add(line);
			line = reader2.readLine();
		}
		List<Pair<String, ChineseVocabularyEntry>> result = helper.getSubdictionary(vocabulary);

		StringBuilder text = new StringBuilder();
		for (Pair<String, ChineseVocabularyEntry> pair : result) {

			String key = pair.getRight().getPinyinTranslations().get(0).getLeft();
			String value = pair.getRight().getPinyinTranslations().get(0).getRight().toString();
			key = key.replace("<", "(");
			key = key.replace(">", ")");
			key = key.replace("&", "und");
			value = value.replace("<", "(");
			value = value.replace(">", ")");
			value = value.replace("&", "und");

			text.append("<void method='add'><object class='net.sf.gluebooster.demos.pojo.languages.VocabularyEntry'><void index='0'><string>")
					.append(pair.getLeft()).append("</string></void><void index='1'><string>").append(key)
					.append("</string></void><void index='2'><object class='java.util.ArrayList'><void method='add'><string>")
					.append(value).append("</string></void></object></void></object></void>\r\n");
		}

		System.out.println(text);
	}

}