package net.sf.gluebooster.demos.pojo.math;

import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;

import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.TextWithMathMLGenerator;
import net.sf.gluebooster.java.booster.basic.container.BoostedNode;
import net.sf.gluebooster.java.booster.basic.gui.swing.SimpleBeanEditor;
import net.sf.gluebooster.java.booster.basic.meta.DocumentationContext;
import net.sf.gluebooster.java.booster.basic.resources.FileResourceSystem;
import net.sf.gluebooster.java.booster.basic.text.html.HtmlDocumentationWriter;
import net.sf.gluebooster.java.booster.essentials.TestRoot;
import net.sf.gluebooster.java.booster.essentials.container.ResourceSystem;
import net.sf.gluebooster.java.booster.essentials.eventsCommands.CallableAbstraction;
import net.sf.gluebooster.java.booster.essentials.meta.Example;
import net.sf.gluebooster.java.booster.essentials.meta.objects.IoDescription;
import net.sf.gluebooster.java.booster.essentials.utils.DomBoostUtils;

public class MathStudiesTest extends TestRoot {

	/**
	 * Gets a new resource system (below a rootDirectory)
	 * 
	 * @param rootDirectory
	 */
	private ResourceSystem getResourceSystem(File rootDirectory) {
		ResourceSystem resources = new FileResourceSystem(rootDirectory);
		// ResourceSystem resources = new MemoryResourceSystem();

		return resources;
	}

	private String createStudyBookHtml(MathStudies studies, File tempDir, DocumentationContext documentationContext) throws Exception {

		ResourceSystem resources = getResourceSystem(tempDir);
		ArrayList<Locale> additionalLanguages = new ArrayList<>();
		additionalLanguages.add(Locale.ENGLISH);
		// ...
		additionalLanguages.remove(documentationContext.getLocale());

		BoostedNode book = studies.createStudyBook(documentationContext, additionalLanguages);
		HtmlDocumentationWriter htmlWriter = new HtmlDocumentationWriter();
		htmlWriter.setHtmlHeadAppender(new CallableAbstraction<Node, Void>() {
			@Override
			protected Void callImpl(Node... docAndHead) throws Exception {
				Document doc = (Document) docAndHead[0];
				DomBoostUtils.appendElement(doc, docAndHead[1], "style", null, " a {text-decoration: none; color: inherit;}");
				return null;
			}
		});

		htmlWriter.setTextNodeBuilder(new TextWithMathMLGenerator(documentationContext));
		htmlWriter.write(book, new IoDescription(resources, new File("/root")));
		System.out.println(tempDir + "\\root\\index.html");
		StringWriter textwriter = new StringWriter();
		IOUtils.copy(resources.getInputStream("\\root\\index.html"), textwriter);
		String text = textwriter.toString();
		return text;

	}

	//@Test  deaktivated, because it fails sometimes without known reason
	public void smallBookTest() throws Exception {

		MathStudies studies = new MathStudies();
		Statement someStatement = Basics.ANALOGOUS;// to initialize the MathMLGenerator
		MathStudies.termsDefinitionsTranslator.putDefaultValue(Locale.GERMAN, "mathematics.1", "Mathematik 1");
		StudyUnit unit = new StudyUnit(new Statements("mathematics", null), 1, Arrays.asList(ClassesSets.ELEMENT_OF), Collections.EMPTY_LIST);
		studies.setUnits(new StudyUnit[] { unit });

		String text = createStudyBookHtml(studies, createTempDirectory("smallBookTest"), new DocumentationContext(Locale.GERMAN));
	}

	/**
	 * Creates a <a href="de/root/index.html">german math book</a>.
	 */
	@Test
	@Example(clasz = MathStudies.class)
	public void testCreateStudyBook() throws Exception {

		MathStudies studies = new MathStudies();
		studies.setUnits(MathStudies.all());
		File tempRoot = createTempDirectory("MathStudiesTest");

		File tempDir = new File(tempRoot, "de");
		DocumentationContext documentationContext = new DocumentationContext(Locale.GERMAN);
		String text = createStudyBookHtml(studies, tempDir, documentationContext);

		Assert.assertTrue(text.contains("Mathematik"));

		copyExampleResultFiles(tempDir);
		// TODO do more tests

		// tempDir = new File(tempRoot, "en");
		// documentationContext = new DocumentationContext(Locale.ENGLISH);
		// no full translation into english yet
		// text = createStudyBookHtml(studies, tempDir, documentationContext);

		// Assert.assertTrue(text.contains("athematics"));

	}

	@Test
	public void checkIntegrity() throws Exception {

		MathStudies.checkIntegrity(MathStudies.all());
	}
}
