package net.sf.gluebooster.demos.pojo.math.library;

import java.util.Arrays;

import org.junit.Test;

import junit.framework.Assert;
import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;

public class BasicsTest {

	@Test
	public void testToTable() throws Exception {

		Statement mathTable;
		Statement table;
		Object[][] data;

		// mathTable = Basics.mathTable(Arrays.asList(Logic.var("A")), Arrays.asList(Boolean.NOT_FUNCTION));
		// table = Basics.toTable(mathTable);
		// data = table.getRawData();
		// Assert.assertNotNull(data);
		// Assert.assertEquals(3, data.length); // heading + 2 rows
		// Assert.assertEquals(2, data[0].length); // columns A and Not A


		mathTable = Basics.mathTable(Arrays.asList(Logic.var("A"), Logic.var("B")), Arrays.asList(Bool.AND_RELATION));
		table = Basics.toTable(mathTable);
		data = table.getRawData();
		Assert.assertNotNull(data);
		Assert.assertEquals(5, data.length); // heading + 2*2 rows
		Assert.assertEquals(3, data[0].length); // columns A, B and A AND B

		mathTable = Basics.mathTable(Arrays.asList(Logic.var("A"), Logic.var("B")), Arrays.asList(Bool.AND_RELATION, Bool.OR_RELATION));
		table = Basics.toTable(mathTable);
		data = table.getRawData();
		Assert.assertNotNull(data);
		Assert.assertEquals(5, data.length); // heading + 2*2 rows
		Assert.assertEquals(4, data[0].length); // columns A, B, A AND B, A OR B

	}

	/**
	 * Checks that a given column has always (except for the first row) a given value
	 * 
	 * @param rows
	 * @param columnIndex
	 * @param value
	 * @throws Exception
	 */
	public static void checkRows(Object[] rows, int columnIndex, Statement value) throws Exception {
		boolean start = true;
		for (Object row: rows){
			if (start){
				start = false;
			} else {
				Object[] columns = (Object[]) row;
				Assert.assertTrue("Not correct value", value.is((Statement) columns[columnIndex]));
			}
		}
		

	}

}
