package net.sf.gluebooster.demos.pojo.math.library.logic;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.BasicsTest;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;

public class BooleanTest {

	@Test
	public void testProofs() throws Exception {
		Bool.addProofs();

		List<Statement> proofs = Bool.TRANSITIVE_CONDITIONAL.getProofs();
		Assert.assertEquals(1, proofs.size());
		Statement proof = proofs.get(0);
		Object[] rows = proof.getRawData();
		// the last row (the implication) should contain only TRUE
		BasicsTest.checkRows(rows, ((Object[]) rows[0]).length - 1, Bool.VERUM);

	}


}
