package net.sf.gluebooster.demos.pojo.planning.blockworld;

import java.util.HashSet;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;

import net.sf.gluebooster.java.booster.basic.container.BoostedHashSet;
import net.sf.gluebooster.java.booster.basic.container.BoostedNode;
import net.sf.gluebooster.java.booster.basic.math.Operation;
import net.sf.gluebooster.java.booster.basic.math.Operator;
import net.sf.gluebooster.java.booster.basic.math.planning.Planning;
import net.sf.gluebooster.java.booster.basic.transformation.CallableDelegate;

import org.junit.Assert;
import org.junit.Test;

/**
 * Tests planning in the blockworld.
 * 
 * @author CBauer
 *
 */
public class ComplexBlockworldTest implements ErrorListener {

	private static final String BLOCK1_NAME = "block 1";
	private static final String BLOCK2_NAME = "block 2";
	private static final String BLOCK3_NAME = "block 3";

	private boolean hasWarning = false;
	private boolean hasError = false;

	@Test
	public void testNoNeedToSolveComputation() throws Exception {

		// Test FREE_THE_BLOCK
		Block block1 = new Block(BLOCK1_NAME, 0, 0, Blocktype.SINGLEBLOCK,
				Orientation.Y, false);
		Block block2 = new Block(BLOCK2_NAME, 0, 0, Blocktype.DOUBLEBLOCK,
				Orientation.Y, false, BLOCK1_NAME);
		Block block3 = new Block(BLOCK3_NAME, 0, 0, Blocktype.QUADRUPLEBLOCK,
				Orientation.Y, false, BLOCK2_NAME);

		Operation operation = new Operation<Table>();
		operation.setGlobalPrecondition(new Table(10, 10, block1, block2,
				block3));
		operation.setPostcondition(new Table(10, 10, new FreeBlock(block1)));

		Assert.assertFalse(operation.isNoNeedToSolve());
	}

	/**
	 * Tests the expansion of a "Grab block" operation;
	 * 
	 * @throws Exception
	 */
	@Test
	public void testGrabBlockExpansion() throws Exception {
		
		Operation operation5919449= new Operation();
		operation5919449.setSolvingPriority(2147483639);

		Table table5919452= new Table(7, 5, new HashSet());

		Block theBlock5919454= new Block();
		theBlock5919454.setX(0);
		theBlock5919454.setY(0);
		theBlock5919454.setId("Block 2");
		theBlock5919454.setName("Block 2");
		theBlock5919454.setOrientation(Orientation.Y);
		theBlock5919454.setType(Blocktype.DOUBLEBLOCK);
		theBlock5919454.setUp(false);
		theBlock5919454.setOverBlocks(new HashSet<Object>());
		theBlock5919454.getOverBlocks().add("Block 1");
		table5919452.getTableElements().add(theBlock5919454);

		Block theBlock5919457= new Block();
		theBlock5919457.setX(0);
		theBlock5919457.setY(0);
		theBlock5919457.setId("Block 1");
		theBlock5919457.setName("Block 1");
		theBlock5919457.setOrientation(Orientation.Y);
		theBlock5919457.setType(Blocktype.QUADRUPLEBLOCK);
		theBlock5919457.setUp(false);
		theBlock5919457.setOverBlocks(new HashSet<Object>());
		table5919452.getTableElements().add(theBlock5919457);

		Hand theHand5919460= new Hand();
		theHand5919460.setX(0);
		theHand5919460.setY(0);
		theHand5919460.setId("Hand 1");
		theHand5919460.setName("Hand 1");
		theHand5919460.setUp(true);
		theHand5919460.setHasBlock(false);
		table5919452.getTableElements().add(theHand5919460);

		Block theBlock5919463= new Block();
		theBlock5919463.setX(0);
		theBlock5919463.setY(0);
		theBlock5919463.setId("Block 3");
		theBlock5919463.setName("Block 3");
		theBlock5919463.setOrientation(Orientation.Y);
		theBlock5919463.setType(Blocktype.SINGLEBLOCK);
		theBlock5919463.setUp(false);
		theBlock5919463.setOverBlocks(new HashSet<Object>());
		theBlock5919463.getOverBlocks().add("Block 2");
		table5919452.getTableElements().add(theBlock5919463);
		operation5919449.setGlobalPrecondition(table5919452);

		Table table5919467= new Table(7, 5, new HashSet());

		Block theBlock5919469= new Block();
		theBlock5919469.setX(-1);
		theBlock5919469.setY(-1);
		theBlock5919469.setId("Block 3");
		theBlock5919469.setName("Block 3");
		theBlock5919469.setUp(true);
		table5919467.getTableElements().add(theBlock5919469);

		Block theBlock5919472= new Block();
		theBlock5919472.setX(0);
		theBlock5919472.setY(0);
		theBlock5919472.setId("Block 2");
		theBlock5919472.setName("Block 2");
		theBlock5919472.setOrientation(Orientation.Y);
		theBlock5919472.setType(Blocktype.DOUBLEBLOCK);
		theBlock5919472.setUp(false);
		theBlock5919472.setOverBlocks(new HashSet<Object>());
		theBlock5919472.getOverBlocks().add("Block 1");
		table5919467.getTableElements().add(theBlock5919472);

		Block theBlock5919475= new Block();
		theBlock5919475.setX(0);
		theBlock5919475.setY(0);
		theBlock5919475.setId("Block 1");
		theBlock5919475.setName("Block 1");
		theBlock5919475.setOrientation(Orientation.Y);
		theBlock5919475.setType(Blocktype.QUADRUPLEBLOCK);
		theBlock5919475.setUp(false);
		theBlock5919475.setOverBlocks(new HashSet<Object>());
		table5919467.getTableElements().add(theBlock5919475);

		Hand theHand5919478= new Hand();
		theHand5919478.setX(-1);
		theHand5919478.setY(-1);
		theHand5919478.setId("Hand 1");
		theHand5919478.setName("Hand 1");
		theHand5919478.setUp(true);
		theHand5919478.setHasBlock(true);
		theHand5919478.setNameOfBlock("Block 3");
		table5919467.getTableElements().add(theHand5919478);

		Hand theHand5919482= new Hand();
		theHand5919482.setX(0);
		theHand5919482.setY(0);
		theHand5919482.setId("Hand 1");
		theHand5919482.setName("Hand 1");
		theHand5919482.setUp(true);
		theHand5919482.setHasBlock(false);
		table5919467.getTableElements().add(theHand5919482);

		Block theBlock5919485= new Block();
		theBlock5919485.setX(0);
		theBlock5919485.setY(0);
		theBlock5919485.setId("Block 3");
		theBlock5919485.setName("Block 3");
		theBlock5919485.setOrientation(Orientation.Y);
		theBlock5919485.setType(Blocktype.SINGLEBLOCK);
		theBlock5919485.setUp(false);
		theBlock5919485.setOverBlocks(new HashSet<Object>());
		theBlock5919485.getOverBlocks().add("Block 2");
		table5919467.getTableElements().add(theBlock5919485);
		operation5919449.setPostcondition(table5919467);

		Operator theOperator5919489= new Operator();
		theOperator5919489.setName("GRAB_BLOCK");
		theOperator5919489.setAbstractionLevel(3);
		theOperator5919489.setElementary(false);
		operation5919449.setOperator(theOperator5919489);

		Hand theHand5919492= new Hand();
		theHand5919492.setX(-1);
		theHand5919492.setY(-1);
		theHand5919492.setId("Hand 1");
		theHand5919492.setName("Hand 1");
		theHand5919492.setUp(true);
		theHand5919492.setHasBlock(true);
		theHand5919492.setNameOfBlock("Block 3");
		operation5919449.setOperatorDetails(theHand5919492);

		Blockworld blockworld = new Blockworld();
		blockworld.getComputeGlobalPostconditionListener().add(this);
		Planning<Table> planning = new Planning<Table>(
				operation5919449, blockworld);
		BoostedHashSet<BoostedNode> nodesOfConnectedComponents = planning.getPlan().getGraph().getSomeNodesOfTheConnectedComponents();

		planning.transformNode(nodesOfConnectedComponents.iterator().next(),
				BlockworldNodeExpander.grabBlockExpander);

		Assert.assertFalse(hasWarning);
		Assert.assertFalse(hasError);
	}

	@Override
	public void warning(TransformerException exception)
			throws TransformerException {
		hasWarning = true;

	}

	@Override
	public void error(TransformerException exception)
			throws TransformerException {
		hasError = true;

	}

	@Override
	public void fatalError(TransformerException exception)
			throws TransformerException {
		hasError = true;

	}


}
