package net.sf.gluebooster.demos.pojo.prolog;

import java.util.Map;

import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.Query;
import org.jpl7.Term;
import org.jpl7.Variable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

/**
 * Online Prolog: http://swish.swi-prolog.org/
 * 
 * @author cbauer
 *
 */
public class SwiPrologTest {

	@Test
	@Ignore("The atoms and implication is not yet transferred to prolog")
	public void simpleTest() {

		String implies = "implies";
		Atom a = new Atom("a");
		Atom b = new Atom("b");
		Compound aImpliesB = new Compound(implies, new Term[] { a, b });

		Variable X = new Variable();
		Variable Y = new Variable();

		Query query = new Query(implies, new Term[] { X, Y });
		Assert.assertTrue(query.hasSolution());
		Map solution = query.next();
		Assert.assertNotNull(solution);
	}

	// cb.pl contains

	// implies(a,b).
	// implies(b,c).
	// implies(c,a).
	// implies(A,C):- implies(A,B), implies( B,C).
	// iff(X,Y):- implies(X,Y), implies(Y,X).
	//
	// implies(a,b, [implies,a,b, becauseof, proofPart1]).
	// implies(b,c, [implies,b,c, becauseof,proofPart2]).
	// implies(c,a, [implies,c,a, becauseof,proofPart3]).
	// implies(A,C, [implies,A,C, becauseof, transitiv, Proof1, Proof2]):- implies(A,B, Proof1), implies( B,C, Proof2).
	// iff(X,Y,[iff, X, Y, becauseOf, rule1, Proof1, Proof2]):- implies(X,Y, Proof1), implies(Y,X, Proof2).

	@Test
	@Ignore("The file is not yet consulted")
	public void testConnection() {
		// Query query = new Query("consult", new Term[] { new Atom("cb.pl") });
		//
		// Assert.assertTrue("consulted ", query.query());
		//
		// Variable X = new Variable();
		// Variable Y = new Variable();
		// Variable Proof = new Variable();
		//
		// Query q4 = new Query("iff", new Term[] { X, Y, Proof });
		//
		// Map solution = q4.oneSolution();
		//
		// System.out.println("X = " + solution.get(X));
	}
}
