package net.sf.gluebooster.demos.pojo.prolog;

import org.junit.Assert;
import org.junit.Test;

import alice.tuprolog.Int;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.Struct;
import alice.tuprolog.Theory;
import alice.tuprolog.Var;

public class TuPrologTest {

	@Test
	public void testTuProlog1() throws Exception {

		Var varX = new Var("X"), varY = new Var("Y");
		Struct atomP = new Struct("p");
		Struct list = new Struct(atomP, varY); // should be [p|Y]
		System.out.println(list); // prints the list [p|Y]
		Struct fact = new Struct("p", new Struct("a"), new Int(5));
		Struct goal = new Struct("p", varX, new Var("Z"));
		System.out.println("before unify: " + goal); // prints the unified term p(a,5)
		
		Prolog engine = new Prolog();
		boolean res;
		res = goal.unify(engine, fact); // should be X/a, Y/5
		System.out.println(goal); // prints the unified term p(a,5)
		System.out.println(varX); // prints the variable binding X/a


		Var varW = new Var("W");
		res = varW.unify(engine, varY); // should be Z=Y
		System.out.println(varY); // prints just Y, since it is unbound
		System.out.println(varW); // prints the variable binding W / Y
		Struct st = new Struct("q", new Var("Y"), new Var("Y")); // unresolved
		System.out.println(st.getArg(0) == st.getArg(1)); // prints false
		st.resolveTerm(); // now the term is resolved
		// alternatively: res = st.match(new Struct());
		// alternatively: res = st.unify(engine, new Struct());
		System.out.println(st.getArg(0) == st.getArg(1));

	}


	@Test
	public void testTuProlog2() throws Exception {
		Struct clause1 = new Struct(":-", new Struct("p", new Var("X")), new Struct("q", new Var("X")));
		Struct clause2 = new Struct(":-", new Struct("q", new Int(0)), new Struct("true"));
		Struct clause3 = new Struct(":-", new Struct("q", new Int(1)), new Struct("true"));
		System.out.println(clause1 + " is a clause? " + clause1.isClause());
		System.out.println(clause2 + " is a clause? " + clause2.isClause());
		Prolog engine = new Prolog();
		Struct clauseList = new Struct(clause1, new Struct(clause2, new Struct(clause3, new Struct())));
		System.out.println(clauseList + " is a list? " + clauseList.isList());
		Theory t = new Theory(clauseList);
		engine.addTheory(t);
		SolveInfo info = engine.solve("p(X).");
		while (info.isSuccess()) {
			System.out.println("solution: " + info.getSolution() + " - bindings: " + info);
			if (engine.hasOpenAlternatives()) {
				info = engine.solveNext();
			} else {
				break;
			}
		}
	}

	@Test
	public void testTuProlog3() throws Exception {
		Struct atom = new Struct("a");
		Struct functor = new Struct("f");
		String predicate = "p";
		Struct s1 = new Struct(predicate, atom);
		String name = s1.getName();
		Assert.assertEquals(predicate, name);

		// Struct s2 = new Struct(functor, atom);
		// name = s2.getName();
		// Assert.assertEquals(functor.getName(), name);

	}


	@Test
	public void testTuProlog4() throws Exception {
		Struct clause1 = new Struct(":-", new Struct("p", new Int(0)), new Struct("true"));
		Struct clause2 = new Struct(":-", new Struct("q", new Int(0)), new Struct("true"));
		Struct clause3 = new Struct(":-", new Struct("q", new Int(1)), new Struct("true"));
		Prolog engine = new Prolog();
		Struct clauseList = new Struct(clause1, new Struct(clause2, new Struct(clause3, new Struct())));
		System.out.println(clauseList + " is a list? " + clauseList.isList());
		Theory t = new Theory(clauseList);
		engine.addTheory(t);
		SolveInfo info = engine.solve("p(X), q(X).");
		while (info.isSuccess()) {
			System.out.println("solution: " + info.getSolution() + " - bindings: " + info);
			if (engine.hasOpenAlternatives()) {
				info = engine.solveNext();
			} else {
				break;
			}
		}
	}

	@Test
	public void testTuProlog5() throws Exception {
		Struct clause1 = new Struct(":-", new Struct("p", new Int(0)), new Struct("true"));
		Struct clause2 = new Struct(":-", new Struct("q", new Int(0)), new Struct("true"));
		Struct clause3 = new Struct(":-", new Struct("q", new Int(1)), new Struct("true"));
		Prolog engine = new Prolog();
		Struct clauseList = new Struct(clause1, new Struct(clause2, new Struct(clause3, new Struct())));
		System.out.println(clauseList + " is a list? " + clauseList.isList());
		Theory t = new Theory(clauseList);
		engine.addTheory(t);
		Var x = new Var("X");
		SolveInfo info = engine.solve(new Struct(",", new Struct("q", x), new Struct("p", x)));
		while (info.isSuccess()) {
			System.out.println("solution: " + info.getSolution() + " - bindings: " + info);
			if (engine.hasOpenAlternatives()) {
				info = engine.solveNext();
			} else {
				break;
			}
		}
	}

	@Test
	public void testTuPrologLists() throws Exception {
		Var x = new Var("X");
		Var tail = new Var("T");
		Var any = new Var("A");
		Struct clause1 = new Struct(":-", new Struct("member", x, new Struct(x, tail)), new Struct("true"));
		Struct clause2 = new Struct(":-", new Struct("member", x, new Struct(any, tail)), new Struct("member", x, tail));

		Prolog engine = new Prolog();
		Struct clauseList = new Struct(clause1, new Struct(clause2, new Struct()));
		Theory t = new Theory(clauseList);
		engine.addTheory(t);

		Struct a = new Struct("a");
		Struct b = new Struct("b");

		Struct aList = new Struct(a, new Struct(a, new Struct(a, new Struct())));
		Assert.assertTrue(aList.isList());
		SolveInfo info = engine.solve(new Struct("member", a, aList));
		Assert.assertTrue(info.isSuccess());

		info = engine.solve(new Struct("member", b, aList));
		Assert.assertFalse(info.isSuccess());

		Var z = new Var("Z");
		Var remainder = new Var("R");
		Struct list = new Struct(z, remainder);
		info = engine.solve(new Struct("member", z, aList));
		Assert.assertTrue(info.isSuccess());

	}


	@Test
	public void testProofs1() throws Exception {


		Struct verum = new Struct(":-", new Struct("T"), new Struct("true"));
		Struct falsum = new Struct(":-", new Struct("F"), new Struct("true"));

		String AND = "and";
//
		Var x = new Var("X");
		Var y = new Var("Y");
		Var z = new Var("Z");
		Var r1 = new Var("R1");
		Var r2 = new Var("R2");
		Var r = new Var("R");


		// Associative x AND (y AND z) = (x AND y) AND z
		Struct associative = new Struct(":-", new Struct(AND, x, r2, r),
				new Struct(",", new Struct(AND, y, z, r2), new Struct(AND, x, y, r1), new Struct(AND, r1, z, r)));
		
		Struct[] clauses = {
				verum, falsum,

				new Struct(":-", new Struct(AND, verum, verum, verum), new Struct("true")),
				new Struct(":-", new Struct(AND, verum, falsum, falsum), new Struct("true")),
				new Struct(":-", new Struct(AND, falsum, falsum, falsum), new Struct("true")),
				new Struct(":-", new Struct(AND, falsum, verum, falsum), new Struct("true")),
				
				associative
		};

		Prolog engine = new Prolog();
		Struct clauseList = new Struct();
		for (Struct clause : clauses) {
			clauseList = new Struct(clause, clauseList);
		}
		Theory t = new Theory(clauseList);
		engine.addTheory(t);

		// Var a = new Var("A");
		// Var b = new Var("B");
		// Var c = new Var("C");
		//
		// SolveInfo info = engine.solve(new Struct(AND, a, b, c));
		// while (info.isSuccess()) {
		// System.out.println("solution: " + info.getSolution() + " - bindings: " + info);
		// if (engine.hasOpenAlternatives()) {
		// info = engine.solveNext();
		// } else {
		// break;
		// }
		// }
	}

	@Test
	public void testProofs2() throws Exception {

		Var x = new Var("X");
		Var y = new Var("Y");
		Var z = new Var("Z");
		Var tailProof = new Var("Tail");

		String AND = "and";
		String IMPLIES = "implies";

		Struct andCommutative = new Struct(":-", new Struct(AND, x, y, new Struct(new Struct("AND commutative"), tailProof)), new Struct(AND, y, x, tailProof));

		Struct and1True = new Struct(":-", new Struct("True", x, new Struct(new Struct("AND_1"), tailProof)), new Struct(AND, x, y, tailProof));
		Struct and2True = new Struct(":-", new Struct("True", y, new Struct(new Struct("AND_2"), tailProof)), new Struct(AND, x, y, tailProof));

		// Struct impliesTransitive = new Struct(":-", new Struct(IMPLIES, x,z, new Struct(new Struct("IMPLIES TRANSITIVE"), tail)), new Struct(new
		// Struct("AND_2"), tail)), new Struct(AND,x,y, tail));

		//

		// Var r1 = new Var("R1");
		// Var r2 = new Var("R2");
		// Var r = new Var("R");
		//
		// // Associative x AND (y AND z) = (x AND y) AND z
		// Struct associative = new Struct(":-", new Struct(AND, x, r2, r),
		// new Struct(",", new Struct(AND, y, z, r2), new Struct(AND, x, y, r1), new Struct(AND, r1, z, r)));
		//
		// Struct[] clauses = { verum, falsum,
		//
		// new Struct(":-", new Struct(AND, verum, verum, verum), new Struct("true")),
		// new Struct(":-", new Struct(AND, verum, falsum, falsum), new Struct("true")),
		// new Struct(":-", new Struct(AND, falsum, falsum, falsum), new Struct("true")),
		// new Struct(":-", new Struct(AND, falsum, verum, falsum), new Struct("true")),
		//
		// associative };
		//
		// Prolog engine = new Prolog();
		// Struct clauseList = new Struct();
		// for (Struct clause : clauses) {
		// clauseList = new Struct(clause, clauseList);
		// }
		// Theory t = new Theory(clauseList);
		// engine.addTheory(t);
		// // SolveInfo info = engine.solve(new Struct(AND, x, y, z));
		// // while (info.isSuccess()) {
		// // System.out.println("solution: " + info.getSolution() + " - bindings: " + info);
		// // if (engine.hasOpenAlternatives()) {
		// // info = engine.solveNext();
		// // } else {
		// // break;
		// // }
		// // }
	}

}
