package net.sf.gluebooster.demos.pojo.wiki;

import java.io.File;

import javax.swing.JFrame;

import org.junit.Test;

import net.sf.gluebooster.java.booster.essentials.TestRoot;
import net.sf.gluebooster.java.booster.essentials.meta.Example;
import net.sf.gluebooster.java.booster.essentials.utils.GuiBoostUtils;

public class WikiAuthorsTest extends TestRoot {

	@Test
	@Example(clasz = WikiAuthors.class)
	public void documentation() throws Exception {
		final File directory = createTempDirectory("images");

		WikiAuthors gui = new WikiAuthors();
		gui.setPagename("John_von_Neumann");
		gui.setLanguage("en");
		gui.setWiki("wikipedia");
		gui.setWikicode("w");
		gui.setXToolsLink("");

		JFrame frame = gui.getFrame();

		GuiBoostUtils.createScreenshot(directory, "step1", frame, false, true);
		// [gb:useInDocumentation]
		// </pre>Fill in the fields to determine the wikipedia article: <br/><img src="images/step1.png"/><pre>
		// [/gb:useInDocumentation]

		gui.clickSend();
		GuiBoostUtils.createScreenshot(directory, "step2", frame, false, true);
		// [gb:useInDocumentation]
		// </pre>Copy the link to the xtool into the browser: <br/><img src="images/step2.png"/><pre>
		// [/gb:useInDocumentation]
		String xtoolsText = "\r\n" + "* [[John von Neumann]]\r\n" + "* en.wikipedia.org\r\n" + "* Gesamtzahl der Versionen: 4127\r\n"
				+ "* Anzahl Autoren: 1537\r\n" + "* 2016-06-09 19:15:55\r\n" + "\r\n" + "<sup>1</sup> Bearbeitungen<br />\r\n"
				+ "<sup>2</sup> Durchschnittliche Zeit zwischen den Bearbeitungen\r\n" + "{| class=\"wikitable sortable\"\r\n" + "!Benutzername\r\n"
				+ "!#<sup>1</sup>\r\n" + "!Kleine Bearb.\r\n" + "!%\r\n" + "!Erste Bearbeitung\r\n" + "!Aktuellste Bearbeitung\r\n" + "!atbe<sup>2</sup>\r\n"
				+ "!Hinzugefügt (Bytes)	\r\n" + "|-\r\n"
				+ "| [[User:Avaya1|Avaya1]] || 296 || 2 || 0,7 || 2006-08-24, 13:20 || 2015-07-28, 03:13 || 11 || 26.373\r\n" + "|-\r\n"
				+ "| [[User:Hawkeye7|Hawkeye7]] || 240 || 1 || 0,4 || 2015-12-31, 03:49 || 2016-05-26, 12:05 || 0,6 || 131.175\r\n" + "|-\r\n"
				+ "| [[User:Robert K S|Robert K S]] || 92 || 33 || 35,9 || 2006-08-16, 03:31 || 2011-12-06, 00:04 || 21,1 || 3.645\r\n" + "|-\r\n"
				+ "| [[User:24.148.1.17|24.148.1.17]] || 88 || 0 || 0 || 2008-01-10, 21:04 || 2008-03-02, 14:22 || 0,6 || 3.415\r\n" + "|-\r\n"
				+ "| [[User:Skyerise|Skyerise]] || 83 || 6 || 7,2 || 2009-08-03, 01:31 || 2015-05-13, 16:17 || 25,4 || 174\r\n" + "|-\r\n"
				+ "| [[User:RandomTool2|RandomTool2]] || 74 || 7 || 9,5 || 2008-02-22, 22:15 || 2008-11-18, 22:39 || 3,6 || 1.995\r\n" + "|}";
		gui.clickAfterExport(xtoolsText);
		GuiBoostUtils.createScreenshot(directory, "step3", frame, true, true);
		// [gb:useInDocumentation]
		// </pre>Copy the text of the xtools into the clipboard and then click the export button. The modified text has now the correct format to be copied into
		// the discussion page<br/><img src="images/step3.png"/><pre>
		// [/gb:useInDocumentation]
		copyExampleResultFiles(directory);
		// frame.setVisible(false);
		// frame.dispose();

	}

}
