/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaprinciples.metadata;

import au.com.sparxsystems.AggregationType;
import au.com.sparxsystems.Association;
import au.com.sparxsystems.Element;
import au.com.sparxsystems.ElementProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.namespace.QName;
import net.sf.javaprinciples.data.transformer.Transformer;
import net.sf.javaprinciples.metadata.MetadataTransformerBase;
import net.sf.javaprinciples.metadata.ModelElementUtils;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.metadata.ClassMetadata;
import net.sf.javaprinciples.model.metadata.Extension;
import net.sf.javaprinciples.model.metadata.OrderedAssociation;
import net.sf.javaprinciples.model.metadata.impl.ClassMetadataExtensionImpl;
import net.sf.javaprinciples.model.metadata.impl.IdentifierExtensionImpl;
import net.sf.javaprinciples.model.metadata.impl.InstanceExtensionImpl;
import net.sf.javaprinciples.model.shared.ModelObjectFactory;
import net.sf.jcc.model.parser.uml2.ModelElement;
import org.omg.uml.InstanceSpecification;

public class InstanceTransformer
extends MetadataTransformerBase
implements Transformer<ModelElement, AttributeMetadata> {
    private Transformer<ModelElement, ClassMetadata> classMetadataTransformer;
    private QName orderedAssociationNamespace;
    private ModelObjectFactory modelObjectFactory;

    public AttributeMetadata transform(ModelElement input) {
        AttributeMetadata attributeMetadata = (AttributeMetadata)this.modelObjectFactory.createModelObject(AttributeMetadata.class);
        this.mapAttribute(attributeMetadata, input);
        this.mapClassifier(attributeMetadata, input);
        this.mapAssociations(attributeMetadata, input);
        this.mapIdentifier(attributeMetadata, input);
        return attributeMetadata;
    }

    private void mapIdentifier(AttributeMetadata attributeMetadata, ModelElement input) {
        String identifier = input.getGuid();
        IdentifierExtensionImpl identifierExtension = new IdentifierExtensionImpl();
        identifierExtension.setIdentifier(identifier);
        attributeMetadata.getExtensions().add(identifierExtension);
    }

    private void mapAssociations(AttributeMetadata attributeMetadata, ModelElement input) {
        List associations = input.getAssociations();
        if (associations != null && !associations.isEmpty()) {
            InstanceExtensionImpl instanceExtension = new InstanceExtensionImpl();
            Collections.sort(associations, new Comparator<Association>(){

                @Override
                public int compare(Association o1, Association o2) {
                    ModelElement e1 = InstanceTransformer.this.store.get(o1.getIdref().getLocalPart());
                    ModelElement e2 = InstanceTransformer.this.store.get(o2.getIdref().getLocalPart());
                    OrderedAssociation ord1 = (OrderedAssociation)e1.getProfiles().get(InstanceTransformer.this.orderedAssociationNamespace);
                    OrderedAssociation ord2 = (OrderedAssociation)e2.getProfiles().get(InstanceTransformer.this.orderedAssociationNamespace);
                    if (ord1 == null || ord2 == null) {
                        return 0;
                    }
                    return ord1.getIndex() - ord2.getIndex();
                }
            });
            List attributes = instanceExtension.getInstances();
            for (Association association : associations) {
                if (association.getAggregrationType() == AggregationType.SHARED) continue;
                AttributeMetadata associatedAttribute = (AttributeMetadata)this.modelObjectFactory.createModelObject(AttributeMetadata.class);
                String targetIdentifier = association.getTargetClassId();
                ModelElement targetModelElement = this.store.get(targetIdentifier);
                this.mapAttribute(associatedAttribute, targetModelElement);
                IdentifierExtensionImpl identifierExtension = new IdentifierExtensionImpl();
                identifierExtension.setIdentifier(targetIdentifier);
                associatedAttribute.getExtensions().add(identifierExtension);
                attributes.add(associatedAttribute);
            }
            if (!instanceExtension.getInstances().isEmpty()) {
                attributeMetadata.getExtensions().add(instanceExtension);
            }
        }
    }

    private void mapClassifier(AttributeMetadata attributeMetadata, ModelElement input) {
        if (this.classMetadataTransformer == null) {
            return;
        }
        InstanceSpecification instance = (InstanceSpecification)input.getElement();
        List classifiers = instance.getClassifier();
        if (classifiers != null && !classifiers.isEmpty()) {
            String classIdentifier = (String)classifiers.get(0);
            ModelElement classModelElement = this.store.get(classIdentifier);
            ClassMetadataExtensionImpl extension = new ClassMetadataExtensionImpl();
            ClassMetadata classMetadata = (ClassMetadata)this.classMetadataTransformer.transform((Object)classModelElement);
            extension.setClazz(classMetadata);
            extension.setClassname(ModelElementUtils.determineClassname(classModelElement, this.store));
            extension.setMultiplicityMinimum(1);
            extension.setMultiplicityMaximum(1);
            attributeMetadata.getExtensions().add(extension);
        }
    }

    protected void mapExtension(ModelElement modelElement, AttributeMetadata attributeMetadata) {
        List attributeExtensions = attributeMetadata.getExtensions();
        Collection modelExtensions = modelElement.getProfiles().values();
        for (Object extension : modelExtensions) {
            if (!(extension instanceof Extension)) continue;
            attributeExtensions.add((Extension)extension);
        }
    }

    protected void mapAttribute(AttributeMetadata attributeMetadata, ModelElement input) {
        InstanceSpecification instance = (InstanceSpecification)input.getElement();
        Element element = (Element)input.getExtension();
        attributeMetadata.setName(instance.getName());
        ElementProperties properties = element.getProperties();
        if (properties != null) {
            attributeMetadata.setLabel(properties.getAlias());
            attributeMetadata.setDescription(properties.getDocumentation());
        }
        if (attributeMetadata.getLabel() == null) {
            attributeMetadata.setLabel(attributeMetadata.getName());
        }
        this.mapExtension(input, attributeMetadata);
    }

    public void setClassMetadataTransformer(Transformer<ModelElement, ClassMetadata> classMetadataTransformer) {
        this.classMetadataTransformer = classMetadataTransformer;
    }

    public void setOrderedAssociationNamespace(QName orderedAssociationNamespace) {
        this.orderedAssociationNamespace = orderedAssociationNamespace;
    }

    public void setModelObjectFactory(ModelObjectFactory modelObjectFactory) {
        this.modelObjectFactory = modelObjectFactory;
    }
}

