/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaprinciples.metadata;

import java.util.List;
import net.sf.javaprinciples.core.JAXBUtils;
import net.sf.javaprinciples.core.UnexpectedException;
import net.sf.javaprinciples.data.transformer.Transformer;
import net.sf.javaprinciples.metadata.MetadataTransformerBase;
import net.sf.javaprinciples.metadata.ModelElementUtils;
import net.sf.jcc.model.parser.uml2.ModelElement;
import org.omg.uml.InstanceSpecification;
import org.omg.uml.OpaqueExpression;
import org.omg.uml.Property;
import org.omg.uml.Slot;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.core.convert.ConversionService;

public class ObjectStateTransformer<T>
extends MetadataTransformerBase
implements Transformer<ModelElement, T> {
    private ConversionService conversionService;

    public T transform(ModelElement input) {
        InstanceSpecification instanceSpecification = (InstanceSpecification)input.getElement();
        List classifiers = instanceSpecification.getClassifier();
        if (classifiers == null || classifiers.isEmpty()) {
            return null;
        }
        String classIdentifier = (String)classifiers.get(0);
        T target = this.instantiateClassifer((String)classifiers.get(0));
        List slots = instanceSpecification.getSlot();
        if (slots == null || slots.isEmpty()) {
            return target;
        }
        this.assignValuesToTarget(target, slots, input.getGuid());
        return target;
    }

    private void assignValuesToTarget(T target, List<Slot> slots, String identifier) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(target);
        wrapper.setConversionService(this.conversionService);
        for (Slot slot : slots) {
            OpaqueExpression opaqueExpression;
            List body;
            List valueSpecifications = slot.getValue();
            if (valueSpecifications.isEmpty() || (body = (opaqueExpression = (OpaqueExpression)valueSpecifications.get(0)).getBody()) == null || body.isEmpty()) continue;
            String propertyValue = (String)body.get(0);
            if (propertyValue.length() > 1) {
                propertyValue = propertyValue.substring(1);
            }
            String paramClassiferIdentifier = slot.getDefiningClassifier();
            ModelElement paramClassiferElement = this.store.get(paramClassiferIdentifier);
            String propertyName = ((Property)paramClassiferElement.getElement()).getName();
            propertyName = JAXBUtils.nameToIdentifier((String)propertyName, (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.VARIABLE);
            wrapper.setPropertyValue(propertyName, (Object)propertyValue);
        }
        this.setIdentity(identifier, "identifier", (BeanWrapper)wrapper);
    }

    private boolean setIdentity(String identifier, String identityProperty, BeanWrapper wrapper) {
        try {
            wrapper.setPropertyValue(identityProperty, (Object)identifier);
            return true;
        }
        catch (NotWritablePropertyException e) {
            return false;
        }
    }

    private T instantiateClassifer(String classIdentifier) {
        ModelElement classModelElement = this.store.get(classIdentifier);
        String classname = ModelElementUtils.determineClassname(classModelElement, this.store);
        try {
            Class<?> tclass = Class.forName(classname);
            return (T)tclass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedException("Could not find class:" + classname, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new UnexpectedException("Could not instantiate class:" + classname, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException("Illegal access to class:" + classname, (Throwable)e);
        }
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

