/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaprinciples.metadata;

import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.sf.javaprinciples.core.UnexpectedException;
import net.sf.jcc.model.parser.ElementHandler;
import net.sf.jcc.model.parser.ParseContext;
import net.sf.jcc.model.parser.XMLParsedElement;
import net.sf.jcc.model.parser.uml2.ElementStore;
import net.sf.jcc.model.parser.uml2.ModelElement;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.convert.ConversionService;

public class ProfileElementHandler
implements ElementHandler {
    public static final String EXT = "_EXT";
    private String name = this.getClass().getSimpleName();
    private Map<String, Class> classMap;
    private ConversionService conversionService;

    public void handleElement(ParseContext parseContext) {
        Object extension;
        XMLParsedElement pElement = (XMLParsedElement)parseContext.getParsedElement();
        StartElement element = pElement.getElement();
        QName name = element.getName();
        Class clazz = this.classMap.get(name.toString());
        if (clazz == null) {
            return;
        }
        try {
            extension = clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException("Instantiating Extension", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new UnexpectedException("Instantiating Extension", (Throwable)e);
        }
        String guid = null;
        Iterator<Attribute> itr = element.getAttributes();
        BeanWrapperImpl wrapper = new BeanWrapperImpl(extension);
        wrapper.setConversionService(this.conversionService);
        while (itr.hasNext()) {
            Attribute attr = itr.next();
            String attrName = attr.getName().getLocalPart();
            String attrValue = attr.getValue();
            if (attrName.equals("base_Attribute") || attrName.equals("base_Class") || attrName.equals("base_Aggregation") || attrName.equals("base_Object")) {
                guid = attrValue;
                continue;
            }
            wrapper.setPropertyValue(attrName, (Object)attrValue);
        }
        if (guid == null) {
            throw new UnexpectedException("No attribute found with the target guid");
        }
        ElementStore store = (ElementStore)parseContext.getInternalStore();
        ModelElement modelElement = store.get(guid);
        modelElement.addProfile(name, extension);
    }

    public String getName() {
        return this.name;
    }

    public void setClassMap(Map<String, Class> classMap) {
        this.classMap = classMap;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

