/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaprinciples.metadata;

import au.com.sparxsystems.Attribute;
import au.com.sparxsystems.AttributeProperties;
import au.com.sparxsystems.AttributeStyle;
import au.com.sparxsystems.Documentation;
import au.com.sparxsystems.Tag;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import net.sf.javaprinciples.core.UnexpectedException;
import net.sf.javaprinciples.data.transformer.Transformer;
import net.sf.javaprinciples.metadata.MetadataTransformerBase;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.metadata.BusinessObjectMetadata;
import net.sf.javaprinciples.model.metadata.ClassMetadata;
import net.sf.javaprinciples.model.metadata.ClassMetadataExtension;
import net.sf.javaprinciples.model.metadata.EnumerationExtension;
import net.sf.javaprinciples.model.metadata.Extension;
import net.sf.javaprinciples.model.shared.ModelObjectFactory;
import net.sf.javaprinciples.model.shared.ModelSupport;
import net.sf.jcc.model.parser.uml2.ModelElement;
import org.omg.uml.Class;
import org.omg.uml.Enumeration;
import org.omg.uml.EnumerationLiteral;
import org.omg.uml.LiteralBoolean;
import org.omg.uml.LiteralInteger;
import org.omg.uml.LiteralString;
import org.omg.uml.LiteralUnlimitedNatural;
import org.omg.uml.Property;
import org.omg.uml.ValueSpecification;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;

public class UmlPropertyTransformer
extends MetadataTransformerBase
implements Transformer<Property, AttributeMetadata> {
    private Transformer<ModelElement, ClassMetadata> classTransformer;
    private ModelSupport modelSupport;
    private ModelObjectFactory modelObjectFactory;

    public AttributeMetadata transform(Property property) {
        AttributeMetadata attributeMetadata = (AttributeMetadata)this.modelObjectFactory.createModelObject(AttributeMetadata.class);
        ModelElement propertyModelElement = this.store.reverse((Object)property);
        this.map(propertyModelElement, attributeMetadata);
        this.map(property, attributeMetadata);
        Attribute extension = (Attribute)propertyModelElement.getExtension();
        if (extension != null) {
            this.map(extension, (BusinessObjectMetadata)attributeMetadata);
            this.extractType(propertyModelElement, extension, attributeMetadata);
        }
        return attributeMetadata;
    }

    protected void map(ModelElement modelElement, AttributeMetadata attributeMetadata) {
        List attributeExtensions = attributeMetadata.getExtensions();
        Collection modelExtensions = modelElement.getProfiles().values();
        for (Object extension : modelExtensions) {
            attributeExtensions.add((Extension)extension);
        }
    }

    protected void map(Property property, AttributeMetadata attributeMetadata) {
        attributeMetadata.setName(property.getName());
        String minRepeat = null;
        if (!property.getLowerValue().isEmpty()) {
            minRepeat = ((LiteralInteger)property.getLowerValue().get(0)).getValue();
        }
        String maxRepeat = null;
        if (!property.getUpperValue().isEmpty()) {
            ValueSpecification valueSpecification = (ValueSpecification)property.getUpperValue().get(0);
            if (valueSpecification instanceof LiteralInteger) {
                maxRepeat = ((LiteralInteger)valueSpecification).getValue();
            } else if (valueSpecification instanceof LiteralUnlimitedNatural) {
                maxRepeat = "*";
            } else {
                throw new UnexpectedException("Unknown value specification:" + valueSpecification.getClass().getName());
            }
        }
        if (minRepeat != null || maxRepeat != null) {
            int max;
            int min;
            int n = min = minRepeat != null ? Integer.parseInt(minRepeat) : 1;
            int n2 = maxRepeat != null ? ("*".equals(maxRepeat) ? Integer.MAX_VALUE : Integer.parseInt(maxRepeat)) : (max = 1);
            if (min != 1 || max != 1) {
                ClassMetadataExtension classMetadataExtension = (ClassMetadataExtension)this.modelObjectFactory.createModelObject(ClassMetadataExtension.class);
                classMetadataExtension.setMultiplicityMinimum(min);
                classMetadataExtension.setMultiplicityMaximum(max);
                attributeMetadata.getExtensions().add(classMetadataExtension);
            }
        }
        String defaultValue = this.extractDefault(property);
        attributeMetadata.setDefaultValue(defaultValue);
    }

    protected void map(Attribute extension, BusinessObjectMetadata classMetadata) {
        List tags;
        AttributeProperties elementProperties = extension.getProperties();
        if (elementProperties != null) {
            classMetadata.setLabel(extension.getStyle().getValue());
            classMetadata.setDescription(extension.getDocumentation().getValue());
        }
        if (!(tags = extension.getTags()).isEmpty()) {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl((Object)classMetadata);
            for (Tag tag : tags) {
                String tagName = tag.getName();
                String tagValue = tag.getValue();
                if (tagValue == null || !beanWrapper.isWritableProperty(tagName)) continue;
                try {
                    beanWrapper.setPropertyValue(tagName, (Object)tagValue);
                }
                catch (BeansException e) {
                    throw new UnexpectedException("Setting property from tag", (Throwable)e);
                }
            }
        }
    }

    protected String extractDefault(Property property) {
        List defaults = property.getDefaultValue();
        if (defaults.isEmpty()) {
            return null;
        }
        if (defaults.size() != 1) {
            throw new UnexpectedException("Cant handle more than 1 default:" + property.getName());
        }
        ValueSpecification adefault = (ValueSpecification)defaults.get(0);
        if (adefault instanceof LiteralBoolean) {
            return ((LiteralBoolean)adefault).getValue();
        }
        if (adefault instanceof LiteralInteger) {
            return ((LiteralInteger)adefault).getValue();
        }
        if (adefault instanceof LiteralString) {
            return ((LiteralString)adefault).getValue();
        }
        throw new UnexpectedException("Cant handle default:" + adefault.getClass().getName());
    }

    protected void extractType(ModelElement modelElement, Attribute extension, AttributeMetadata metadata) {
        String guid = modelElement.getReference(new QName("type"));
        ModelElement typeModelElement = this.store.get(guid);
        if (typeModelElement != null) {
            Object typeElement = typeModelElement.getElement();
            if (typeElement instanceof Enumeration) {
                metadata.setType("Enumeration");
                this.mapEnumeration((Enumeration)typeElement, metadata);
                return;
            }
            if (typeElement instanceof Class) {
                ClassMetadata classMetadata = (ClassMetadata)this.classTransformer.transform((Object)typeModelElement);
                List extensions = metadata.getExtensions();
                ClassMetadataExtension classMetadataExtension = (ClassMetadataExtension)this.modelSupport.findExtension(extensions, ClassMetadataExtension.class);
                if (classMetadataExtension == null) {
                    classMetadataExtension = (ClassMetadataExtension)this.modelObjectFactory.createModelObject(ClassMetadataExtension.class);
                    classMetadataExtension.setMultiplicityMinimum(1);
                    classMetadataExtension.setMultiplicityMaximum(1);
                    extensions.add(classMetadataExtension);
                }
                classMetadataExtension.setClazz(classMetadata);
            }
        }
        metadata.setType(extension.getProperties().getType());
    }

    protected void mapEnumeration(Enumeration enumerationModel, AttributeMetadata metadata) {
        EnumerationExtension enumerationExtension = (EnumerationExtension)this.modelObjectFactory.createModelObject(EnumerationExtension.class);
        List listItems = enumerationExtension.getListItems();
        for (EnumerationLiteral property : enumerationModel.getOwnedLiteral()) {
            AttributeStyle style;
            BusinessObjectMetadata listItem = (BusinessObjectMetadata)this.modelObjectFactory.createModelObject(BusinessObjectMetadata.class);
            listItem.setName(property.getName());
            ModelElement modelElement = this.store.reverse((Object)property);
            Attribute attribute = (Attribute)modelElement.getExtension();
            if (attribute == null) {
                throw new RuntimeException("No extension found for: " + modelElement.getGuid());
            }
            Documentation documentation = attribute.getDocumentation();
            if (documentation != null) {
                listItem.setDescription(documentation.getValue());
            }
            if ((style = attribute.getStyle()) != null) {
                listItem.setLabel(style.getValue());
            }
            listItems.add(listItem);
        }
        metadata.getExtensions().add(enumerationExtension);
    }

    public void setClassTransformer(Transformer<ModelElement, ClassMetadata> classTransformer) {
        this.classTransformer = classTransformer;
    }

    public void setModelSupport(ModelSupport modelSupport) {
        this.modelSupport = modelSupport;
    }

    public void setModelObjectFactory(ModelObjectFactory modelObjectFactory) {
        this.modelObjectFactory = modelObjectFactory;
    }
}

