package net.sf.javaprinciples.graph;

/**
 * A Graph is a hierarchical structure of names and values.
 * The value may be a primitive, an array or another structure.
 *
 * The reader is intended for an environment where the structure of the graph is understood from
 * some other schema. Hence it does not provide any methods for determining whether the value
 * is an array, a primitive or class.
 *
 * The reader is an iterator over the graph. At any point time the reader
 * is located at a node.
 *
 * If the readArray or readObject methods are used on an property that is not an array or or
 * an object then an UnexpectedException will be thrown.
 *
 * @author Warwick Slade
 */
public interface GraphReader
{
    /**
     * Retrieve the property of the specified name
     * @param name
     * @return May be null if the property is not present or if the value is null
     */
    public String readString(String name);

    /**
     * Move to the first element in the array for the given property.
     * @return true when the array has atleast on element
     */
    public boolean readArray(String name);

    /**
     * Moved to the next array node
     * @return true when there is another element in the array
     */
    public boolean readArray();

    /**
     * Moved to the object for the given property
     * @return true when there is a property with this name
     */
    public boolean readObject(String name);

    /**
     * Move back up
     */
    public void readObject();
}
