package net.sf.javaprinciples.graph;

/**
 * A Graph is a hierarchical structure of names and values.
 * The value may be a primitive, an array or another structure.
 *
 * The writer is intended for an environment where the structure of the graph is understood from
 * some other schema. The writer is not intended for hand written use, rather use by an
 * automation process.
 *
 * The writer is an iterator over the graph. At any point time the writer
 * is located at a node.
 *
 * @author Warwick Slade
 */
public interface GraphWriter
{
    /**
     * Retrieve the property of the specified name
     * @param name Must not be blank
     * @param value May be null
     * @return May be null if the property is not present
     */
    public void writeString(String name, String value);

    /**
     * Move to the first element in the array for the given property.
     */
    public void writeArray(String name);

    /**
     * Moved to the next array node
     */
    public void writeArray();

    /**
     * Moved to the object for the given property
     */
    public void writeObject(String name);

    /**
     * Writing the object is complete
     */
    public void writeObject();

    /**
     * An error processing a node
     * @param message
     */
    public void reportError(String message);

    boolean hasErrors();
}
