package net.sf.javaprinciples.graph.impl;

import net.sf.javaprinciples.graph.GraphReader;

/**
 * A reader for when there is no data.
 *
 * @author Warwick Slade
 */
public class EmptyGraphReader implements GraphReader
{
    @Override
    public String readString(String name)
    {
        return null;
    }

    @Override
    public boolean readArray(String name)
    {
        return false;
    }

    @Override
    public boolean readArray()
    {
        return false;
    }

    @Override
    public boolean readObject(String name)
    {
        return false;
    }

    @Override
    public void readObject()
    {
    }
}
