package net.sf.javaprinciples.graph.json;

import java.util.Stack;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;

import net.sf.javaprinciples.graph.GraphReader;

/**
 *
 *
 * @author Warwick Slade
 */
public class JsonGraphReader implements GraphReader
{
    private JSONValue current;
    Stack<JSONValue> stack = new Stack<JSONValue>();

    public JsonGraphReader(String source)
    {
        this.current = JSONParser.parseStrict(source);
    }

    @Override
    public String readString(String name)
    {
        if (current == null || !(current instanceof JSONObject))
        {
            return null;
        }

        JSONObject object = ((JSONObject)current);
        JSONValue value = object.get(name);

        if (value == null || (value.isNull() instanceof JSONNull))
        {
            return null;
        }

        JSONString stringValue = value.isString();
        if (stringValue == null)
        {
            return null;
        }
        return stringValue.stringValue();
    }

    @Override
    public boolean readArray(String name)
    {
        if (name == null)
        {
            JSONArray array = (JSONArray)stack.peek();
            for (int i = 0; i < array.size(); i++)
            {
                JSONValue value = array.get(i);
                if (current.equals(value))
                {
                    // Is last
                    if ((i + 1) == array.size())
                    {
                        return false;
                    }
                    current = array.get(i + 1);
                    return true;
                }
            }
            throw new RuntimeException("Never found the current in the array");
        }

        if (current == null || !(current instanceof JSONObject))
        {
            return false;
        }

        JSONObject object = ((JSONObject)current);
        JSONValue value = object.get(name);

        if (value.isNull() instanceof JSONNull)
        {
            return false;
        }

        JSONArray array = value.isArray();

        if (array == null)
        {
            throw new RuntimeException("Expected an array for attribute:" + name);
        }

        stack.push(current);
        stack.push(array);
        current = array.get(0);
        return true;
    }

    @Override
    public boolean readArray()
    {
        stack.pop();  // Pop the array
        current = stack.pop();
        return true;
    }

    @Override
    public boolean readObject(String name)
    {
        if (current == null || !(current instanceof JSONObject))
        {
            return false;
        }

        JSONValue object = ((JSONObject) current).get(name);

        if (object == null)
        {
            return false;
        }

        if (!(object instanceof JSONObject))
        {
            throw new RuntimeException("Node is not an object:" + name);
        }

        stack.push(current);
        current = object;
        return true;
    }

    @Override
    public void readObject()
    {
        current = stack.pop();
    }

    public String toString()
    {
        return current.toString();
    }
}
