package net.sf.javaprinciples.model.overlay;

import java.util.ArrayList;
import java.util.List;
import com.google.gwt.core.client.JsArray;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.metadata.Extension;

public class AttributeMetadataOverlay extends BusinessObjectMetadataOverlay implements AttributeMetadata {
    protected AttributeMetadataOverlay() {}

    @Override
    public final native boolean isReadOnly()
    /*-{
        return (this.readOnly) ? this.readOnly : false;
    }-*/;

    @Override
    public final native void setReadOnly(boolean value)
    /*-{
        this.readOnly = value;
    }-*/;

    @Override
    public final native boolean isHidden()
    /*-{
        return (this.hidden) ? this.hidden: false;
    }-*/;

    @Override
    public final native void setHidden(boolean value)
    /*-{
        this.hidden = value;
    }-*/;

    @Override
    public final native boolean isOptional()
    /*-{
        return (this.optional) ? this.optional : false;
    }-*/;

    @Override
    public final native void setOptional(boolean value)
    /*-{
        this.optional = value;
    }-*/;

    @Override
    public final native String getControlName()
    /*-{
        return (this.controlName) ? this.controlName : null;
    }-*/;

    @Override
    public final native void setControlName(String value)
    /*-{
        this.controlName = value;
    }-*/;

    @Override
    public final native String getControlFactory()
    /*-{
        return (this.controlFactory) ? this.controlFactory : null;
    }-*/;

    @Override
    public final native void setControlFactory(String value)
    /*-{
        this.controlFactory = value;
    }-*/;

    @Override
    public final native String getDefaultValue()
    /*-{
        return (this.defaultValue) ? this.defaultValue : null;
    }-*/;

    @Override
    public final native void setDefaultValue(String value)
    /*-{
        this.defaultValue = value;
    }-*/;

    @Override
    public final List<Extension> getExtensions()
    {
        JsArray<ExtensionOverlay> jsExtensions = processArray("extension");
        return populateListFromJsArray(new ArrayList<Extension>(), jsExtensions);
    }
}
