package net.sf.javaprinciples.model.overlay;

import net.sf.javaprinciples.model.metadata.SubmitAction;
import net.sf.javaprinciples.model.metadata.ViewExtension;
import net.sf.javaprinciples.model.metadata.ViewType;

public class ViewExtensionOverlay extends ExtensionOverlay implements ViewExtension
{
    protected ViewExtensionOverlay() {}

    @Override
    public final native String getName()
    /*-{
        return this.name;
    }-*/;

    @Override
    public final native void setName(String value)
    /*-{
        this.name = value;
    }-*/;

    @Override
    public final native String getContent()
    /*-{
        return this.content;
    }-*/;

    @Override
    public final native void setContent(String value)
    /*-{
        this.content = value;
    }-*/;

    @Override
    public final ViewType getType()
    {
        return ViewType.fromValue(getTypeInternal());
    }

    private final native String getTypeInternal()
    /*-{
        return this.type;
    }-*/;

    @Override
    public final native void setType(ViewType value)
    /*-{
        this.type = value; //.net.sf.javaprinciples.model.metadata.ViewType::value;
    }-*/;

    @Override
    public final SubmitAction getSubmitAction()
    {
        // Maybe the model should be responsible for defaulting the value
        String submitAction = getSubmitActionInternal();
        if (submitAction == null)
        {
            return SubmitAction.BACK;
        }
        return SubmitAction.fromValue(submitAction);
    }

    private final native String getSubmitActionInternal()
    /*-{
        return this.submitAction;
    }-*/;

    @Override
    public final native void setSubmitAction(SubmitAction value)
    /*-{
        this.submitAction = value; //.net.sf.javaprinciples.model.metadata.SubmitAction::value;
    }-*/;

    @Override
    public final native String getAction()
    /*-{
        return this.action;
    }-*/;

    @Override
    public final native void setAction(String value)
    /*-{
        this.action = value;
    }-*/;

    @Override
    public final native String getDescription()
    /*-{
        return this.description;
    }-*/;

    @Override
    public final native void setDescription(String value)
    /*-{
        this.description = value;
    }-*/;

    @Override
    public final native boolean isReadOnly()
    /*-{
        return this.readOnly;
    }-*/;

    @Override
    public final native void setReadOnly(boolean value)
    /*-{
        this.readOnly = value;
    }-*/;

    @Override
    public final native boolean isDisabled()
    /*-{
        return this.disabled;
    }-*/;

    @Override
    public final native void setDisabled(boolean value)
    /*-{
        this.disabled = value;
    }-*/;
}
