package net.sf.javaprinciples.model.service.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.jsonp.client.JsonpRequestBuilder;

import net.sf.javaprinciples.model.service.JsonModelServiceAsync;

public class JsonModelServiceAsyncImpl implements JsonModelServiceAsync
{
    private JsonpRequestBuilder jsonp;
    private String requestPath;

    public JsonModelServiceAsyncImpl(String requestPath)
    {
        this.jsonp = new JsonpRequestBuilder();
        this.requestPath = requestPath;
    }

    @Override
    public void findModel(String identifier, RequestCallback callback)
    {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.GET,
                GWT.getModuleBaseURL() + requestPath + "/model/" + identifier);
        rb.setCallback(callback);
        try
        {
            rb.send();
        }
        catch (RequestException re)
        {
            throw new RuntimeException(re); // Dodgy...
        }
    }
}
