package net.sf.javaprinciples.presentation.activity;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.GWT.UncaughtExceptionHandler;

import net.sf.javaprinciples.model.shared.StringUtilsShared;

/**
 * The Entry point for the client.
 */
public class ActivityEntryPoint implements EntryPoint, UncaughtExceptionHandler
{
	@Override
	public void onModuleLoad() 
	{
		GWT.setUncaughtExceptionHandler(this);

		GWT.create(ClientContext.class);
	}

	@Override
	public void onUncaughtException(Throwable e) 
	{
        String message = e.getMessage();
        if (StringUtilsShared.isBlank(message))
        {
            message = "unCaughtException";
        }
        e.printStackTrace();
        GWT.log(message, e);
		MessageBox.dialogBox("An error has occurred loading your page", message);
	}
}
