package net.sf.javaprinciples.presentation.activity;

import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.place.shared.Place;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.shared.ModelSupport;
import net.sf.javaprinciples.presentation.activity.model.ModelViewFactory;
import net.sf.javaprinciples.presentation.view.ViewFactory;
import net.sf.javaprinciples.presentation.widget.WidgetFactory;

public interface ClientContext
{
    void gotoPlace(Place place);

    ViewFactory getViewFactory();
    ModelSupport getModelSupport();
    WidgetFactory getWidgetFactory();
    ModelViewFactory getModelViewFactory();

    void raiseStatusMessage(String detail);
    void raiseStatusMessage(String detail, boolean isError);
    void clearStatusMessage();
    void raiseEvent(GwtEvent<?> event);

    interface ModelAsynchCall
    {
        void modelReady(String identifier, AttributeMetadata model);
        void modelFail(String identifier, String reason);
    }

    void loadModel(String identifier, ModelAsynchCall callback);

    interface RetrieveContentAsynchCall
    {
        void contentReady(String identifier, String content);
        void contentFail(String identifier, String reason);
    }

    void retrieveContent(String identifier, String query, RetrieveContentAsynchCall callback);

    interface StoreContentAsynchCall
    {
        void storeSuccess(String identifier, String detail);
        void storeFail(String identifier, String reason);
    }
    void storeContent(String name, String content, StoreContentAsynchCall callback);
}
