package net.sf.javaprinciples.presentation.activity;

import java.util.HashMap;
import java.util.Map;
import com.google.gwt.activity.shared.ActivityManager;
import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.EventBus;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.place.shared.PlaceHistoryHandler;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import net.sf.javaprinciples.model.metadata.ViewType;
import net.sf.javaprinciples.model.shared.ModelObjectFactory;
import net.sf.javaprinciples.model.shared.ModelSupport;
import net.sf.javaprinciples.presentation.activity.model.ModelViewFactory;
import net.sf.javaprinciples.presentation.activity.model.ModelViewFactoryImpl;
import net.sf.javaprinciples.presentation.activity.model.ViewBuilder;
import net.sf.javaprinciples.presentation.activity.model.builder.FormViewBuilder;
import net.sf.javaprinciples.presentation.activity.model.builder.ListViewBuilder;
import net.sf.javaprinciples.presentation.activity.model.builder.MenuViewBuilder;
import net.sf.javaprinciples.presentation.activity.model.builder.RedirectViewBuilder;
import net.sf.javaprinciples.presentation.activity.model.builder.SearchViewBuilder;
import net.sf.javaprinciples.presentation.component.HeaderComponent;
import net.sf.javaprinciples.presentation.event.ModelAdapter;
import net.sf.javaprinciples.presentation.event.RetrieveContentAdapter;
import net.sf.javaprinciples.presentation.event.StoreContentAdapter;
import net.sf.javaprinciples.presentation.view.ViewFactory;
import net.sf.javaprinciples.presentation.view.ViewFactoryBuilder;
import net.sf.javaprinciples.presentation.widget.WidgetFactory;
import net.sf.javaprinciples.presentation.widget.WidgetFactoryBuilder;

public class ClientContextImpl implements ClientContext
{
	private final EventBus eventBus = new SimpleEventBus();
	private final PlaceController placeController = new PlaceController(eventBus);
	private final WidgetFactory widgetFactory;
    private final ViewFactory viewFactory;

    private final ModelObjectFactory modelObjectFactory;
    private final ModelSupport modelSupport;
    private final StoreContentAdapter storeContentAdapter;
    private final RetrieveContentAdapter retrieveContentAdapter;
    private final ModelAdapter modelAdapter;
    private HeaderComponent headerComponent;

	public ClientContextImpl()
	{
        ApplicationContext applicationContext = GWT.create(ApplicationContext.class);

        String resourcePath = applicationContext.resourcePath();
        storeContentAdapter = new StoreContentAdapter(eventBus, resourcePath);
        retrieveContentAdapter = new RetrieveContentAdapter(eventBus, resourcePath);
        modelAdapter = new ModelAdapter(eventBus, resourcePath);

        modelObjectFactory = GWT.create(ModelObjectFactory.class);
        modelSupport = GWT.create(ModelSupport.class);

        headerComponent = new HeaderComponent(eventBus);
        init(applicationContext);

        WidgetFactoryBuilder widgetFactoryBuilder = GWT.create(WidgetFactoryBuilder.class);
        widgetFactory = widgetFactoryBuilder.build(this);

        ViewFactoryBuilder viewFactoryBuilder = GWT.create(ViewFactoryBuilder.class);
        viewFactory = viewFactoryBuilder.build(this);
    }

    @Override
    public void gotoPlace(Place place)
    {
        if (place == null)
        {
            History.back();
            return;
        }
        placeController.goTo(place);
    }

    @Override
    public ModelViewFactory getModelViewFactory()
    {
        Map<ViewType, ViewBuilder> views = new HashMap<ViewType, ViewBuilder>();
        views.put(ViewType.SEARCH, new SearchViewBuilder());
        views.put(ViewType.MENU, new MenuViewBuilder());
        views.put(ViewType.FORM, new FormViewBuilder());
        views.put(ViewType.LIST, new ListViewBuilder());
        views.put(ViewType.REDIRECT, new RedirectViewBuilder());
        return new ModelViewFactoryImpl(views);
    }

    @Override
    public void raiseStatusMessage(String detail)
    {
        raiseStatusMessage(detail, false);
    }

    @Override
    public void raiseStatusMessage(String detail, boolean isError)
    {
        raiseEvent(new HeaderComponent.StatusChangeEvent(detail, true, isError));
    }

    @Override
    public void clearStatusMessage()
    {
        raiseEvent(new HeaderComponent.StatusChangeEvent(null, false, false));
    }

    @Override
    public void raiseEvent(GwtEvent<?> event)
    {
        eventBus.fireEvent(event);
    }

    //@Override
	public void loadModel(String name, ModelAsynchCall callback)
	{
        modelAdapter.loadModel(name, callback);
	}

    @Override
    public void retrieveContent(String identifier, String query, RetrieveContentAsynchCall callback)
    {
        retrieveContentAdapter.retrieveContent(identifier, query, callback);
    }

    public void storeContent(String identifier, String content, StoreContentAsynchCall callback)
    {
        storeContentAdapter.storeContent(identifier, content, callback);
    }

    private SimplePanel appWidget = new SimplePanel();

    private void init(ApplicationContext applicationContext)
    {
        // Start ActivityManager for the main widget with our ActivityMapper
        ActivityMapper activityMapper = applicationContext.activityMapper(this);
        ActivityManager activityManager = new ActivityManager(activityMapper, eventBus);
        activityManager.setDisplay(appWidget);

        // Start PlaceHistoryHandler with our PlaceHistoryMapper
        final PlaceHistoryMapper historyMapper = applicationContext.placeHistoryMapper();
        PlaceHistoryHandler historyHandler = new PlaceHistoryHandler(historyMapper);
        historyHandler.register(placeController, eventBus, applicationContext.defaultPlace());

        RootPanel.get("pageContent").add(appWidget);

        applicationContext.initialise(this);

        // Goes to the place represented on URL else default place
        historyHandler.handleCurrentHistory();

        History.addValueChangeHandler(new ValueChangeHandler<String>()
        {
            @Override
            public void onValueChange(ValueChangeEvent<String> event)
            {
                Place place = historyMapper.getPlace(event.getValue());
                if (place != null)
                {
                    placeController.goTo(place);
                }
            }
        });
    }

    public ModelSupport getModelSupport()
    {
        return modelSupport;
    }


    @Override
    public ViewFactory getViewFactory()
    {
        return viewFactory;
    }

    @Override
    public WidgetFactory getWidgetFactory()
    {
        return widgetFactory;
    }
}
