package net.sf.javaprinciples.presentation.activity;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;

public class MessageBox 
{
	private String title;
	private String message;
	private Style style;
	
	public enum Style 
	{
		OK, OK_CANCEL
	};

	public static void dialogBox(String title, String error)
	{
	   	  MessageBox box = new MessageBox();
	   	  box.setTitle(title);
	   	  box.setMessage(error);
	   	  box.show(null);
	}

	
	public interface Handler 
	{
		public void onClose();
	}

	public void show(final Handler handler) 
	{
		// Create the popup dialog box
		final DialogBox dialogBox = new DialogBox();
		dialogBox.setText("Event Secretary");
		dialogBox.setAnimationEnabled(true);
		dialogBox.setGlassEnabled(true);
		// dialogBox.setWidth("800px");
		VerticalPanel dialogVPanel = new VerticalPanel();
		dialogVPanel.addStyleName("dialogVPanel");
		dialogVPanel.add(new HTML("<b>" + title + "</b>"));
		dialogVPanel.add(new HTML("<br><b>" + message + "</b><br><br>"));
		dialogVPanel.setHorizontalAlignment(VerticalPanel.ALIGN_CENTER);
		
		HorizontalPanel buttons = new HorizontalPanel();
		dialogVPanel.add(buttons);
		
		Button ok = new Button("OK");
		buttons.add(ok);
		
		// Add a handler to close the DialogBox
		ok.addClickHandler(new ClickHandler() 
		{
			public void onClick(ClickEvent event) 
			{
				dialogBox.hide();
				if (handler != null)
				{
					handler.onClose();
				}
			}
		});
		if (style == Style.OK_CANCEL)
		{
			Label gap = new Label("");
			gap.setWidth("10px");
			buttons.add(gap);
			Button cancel = new Button("Cancel");
			buttons.add(cancel);
			cancel.addClickHandler(new ClickHandler() 
			{
				public void onClick(ClickEvent event) 
				{
					dialogBox.hide();
				}
			});
		}

		dialogBox.setWidget(dialogVPanel);
		dialogBox.center();
		ok.setFocus(true);
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public Style getStyle() {
		return style;
	}

	public void setStyle(Style style) {
		this.style = style;
	}
}
