package net.sf.javaprinciples.presentation.activity.model;

import java.util.List;
import net.sf.javaprinciples.model.metadata.Extension;
import net.sf.javaprinciples.model.overlay.TypeReportable;
import net.sf.javaprinciples.model.shared.ModelSupport;

public class ClientModelSupport implements ModelSupport
{
    /**
     * Implementation of findExtension for client-side use.
     * Ideally we will use GWT rebinding to create the "correct" ModelUtils implementation in the client, we're
     * just not there yet.
     *
     * @param extensions  A list that may be empty
     * @param classToFind The type of model element we wish to find, never null.
     * @param <T>         The interface-level type of the model element.
     * @return The model element if found, or may be null if not found.
     */
    @Override
    public <T extends Extension> T findExtension(List<Extension> extensions, Class<T> classToFind)
    {
        String className = classToFind.getName();
        for (Extension extension : extensions)
        {
            logit((TypeReportable)extension, ((TypeReportable)extension).reportType());
            if (((TypeReportable) extension).reportType().equals(className))
            {
                return (T) extension;
            }
        }
        return null;
    }

    private static final native void logit(TypeReportable object, String type)
        /*-{
            var keys = Object.keys(object);
            console.log(type + "[" + keys.length + "]");
            console.log(keys);
            for (i=0; i<keys.length;i++)
            {
                console.log(keys[i] + " [" + typeof(object[keys[i]]) + "] : " + object[keys[i]]);
            }
        }-*/;
}
