package net.sf.javaprinciples.presentation.activity.model;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;

import net.sf.javaprinciples.graph.GraphReader;
import net.sf.javaprinciples.graph.impl.EmptyGraphReader;
import net.sf.javaprinciples.graph.json.JsonGraphReader;
import net.sf.javaprinciples.model.metadata.AttributeMetadata;
import net.sf.javaprinciples.model.shared.StringUtilsShared;
import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.activity.MessageBox;
import net.sf.javaprinciples.presentation.view.model.ModelView;

public class ModelActivity extends AbstractActivity
{
	private ClientContext clientContext;
	private ModelPlace place;
	private boolean started;
    private boolean modelLoaded;
    private boolean contentLoaded;

    private ModelView view;

	public ModelActivity(final ClientContext clientContext)
	{
		this.clientContext = clientContext;
	}

	public void setPlace(ModelPlace place)
	{
		this.place = place;
	}

	@Override
	public void onStop() 
	{
		started = false;
        modelLoaded = false;
        contentLoaded = false;
	}

    public static native boolean isIE8() /*-{
        if (document.all && !document.querySelector) {
            return true;
        }
        return false;
    }-*/;


    @Override
	public void start(AcceptsOneWidget root, EventBus eventBus)
	{
        if (isIE8())
        {
            RootPanel.get("loading").setVisible(false);
            FlowPanel div = new FlowPanel();
            div.setStyleName("container-fluid");

            FlowPanel container = new FlowPanel();
            container.setStylePrimaryName("row col-xs-12 col-xs-offset-0 col-sm-6 col-sm-offset-3 col-md-4 col-md-offset-4");

            FlowPanel flow = new FlowPanel();
            flow.setStyleName("form-group alert alert-danger text-center", true);
            HTML html = new HTML("We are terribly sorry however your browser has too many security issues for us to allow you access to the Online Membership Database.<br>Please upgrade your browser.");
            html.setStyleName("control-label");
            flow.add(html);

            container.add(flow);
            div.add(container);
            root.setWidget(div);
            return;
        }

		started = true;
		RootPanel.get("loading").setVisible(true);

		root.setWidget(view);

        String content = place.getContent();

        if (content != null)
        {
            clientContext.retrieveContent(place.getModel(), content, new ClientContext.RetrieveContentAsynchCall()
            {
                @Override
                public void contentReady(String identifier, String content)
                {
                    try
                    {
                        GraphReader reader = new JsonGraphReader(content);
                        view.setContent(reader);
                        contentLoaded = true;
                        checkReady(view);
                    }
                    catch (Exception e)
                    {
                        String message = e.getMessage();
                        if (StringUtilsShared.isBlank(message))
                        {
                            message = "Internal Error";
                        }
                        RootPanel.get("loading").setVisible(false);
                        MessageBox.dialogBox("Failure presenting content", message);
                    }
                }

                @Override
                public void contentFail(String identifier, String reason)
                {
                    RootPanel.get("loading").setVisible(false);
                    MessageBox.dialogBox("YYYYYYY", reason);
                }
            });
        }
        else
        {
            view.setContent(new EmptyGraphReader());
            contentLoaded = true;
        }

        clientContext.loadModel(place.getModel(), new ClientContext.ModelAsynchCall()
        {
            @Override
            public void modelReady(String name, AttributeMetadata model)
            {
                view.setModel(model);
                modelLoaded = true;
                checkReady(view);
            }

            @Override
            public void modelFail(String name, String reason)
            {
                RootPanel.get("loading").setVisible(false);
                MessageBox.dialogBox("XXXXXXXX", reason);
            }
        });
    }

    protected void checkReady(ModelView view)
    {
        if (modelLoaded && contentLoaded)
        {
            view.layout();
            RootPanel.get("loading").setVisible(false);
        }
    }

    public void setView(ModelView view)
    {
        this.view = view;
    }
}
