package net.sf.javaprinciples.presentation.activity.model;


import java.util.HashMap;
import java.util.Map;

import com.google.gwt.activity.shared.Activity;
import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.place.shared.Place;

import net.sf.javaprinciples.model.metadata.ViewType;
import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.view.ViewFactory;
import net.sf.javaprinciples.presentation.view.model.FormView;
import net.sf.javaprinciples.presentation.view.model.ListView;
import net.sf.javaprinciples.presentation.view.model.MenuView;
import net.sf.javaprinciples.presentation.view.model.RedirectView;
import net.sf.javaprinciples.presentation.view.model.SearchView;

public class ModelActivityMapper implements ActivityMapper
{
    private ClientContext clientContext;
    private Map<ModelPlace, ModelActivity> activities = new HashMap<ModelPlace, ModelActivity>();

	public ModelActivityMapper(ClientContext clientContext)
	{
        this.clientContext = clientContext;
	}

	@Override
	public Activity getActivity(Place place) 
	{
        if (place instanceof ModelPlace)
        {
            ModelPlace mplace = (ModelPlace) place;

            ModelActivity activity = activities.get(mplace);

            if (activity != null)
            {
                return activity;
            }

            String useCase = mplace.getUseCase();

            activity = new ModelActivity(clientContext);
            ViewType viewType = null;
            try
            {
                viewType = ViewType.fromValue(useCase);
            }
            catch (IllegalArgumentException iae)
            {
                throw new RuntimeException("Invalid use case:" + useCase);
            }

            ModelViewFactory viewFactory = clientContext.getModelViewFactory();
            activity.setView(viewFactory.createViewForUsecase(viewType, clientContext));

            activity.setPlace(mplace);
            activities.put(mplace, activity);
            return activity;
        }
        return null;
	}

}
