package net.sf.javaprinciples.presentation.activity.model;

import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.core.client.GWT;
import com.google.gwt.place.shared.PlaceHistoryMapper;

import net.sf.javaprinciples.presentation.activity.ApplicationContext;
import net.sf.javaprinciples.presentation.activity.ClientContext;

/**
 *
 * @author Warwick Slade
 */
public abstract class ModelApplicationContext implements ApplicationContext
{
    @Override
    public String resourcePath()
    {
        return "resources";
    }

    @Override
    public ActivityMapper activityMapper(ClientContext clientContext)
    {
        return new ModelActivityMapper(clientContext);
    }

    @Override
    public PlaceHistoryMapper placeHistoryMapper()
    {
        return GWT.create(ModelPlaceHistoryMapper.class);
    }
}
