package net.sf.javaprinciples.presentation.activity.model;

import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceTokenizer;

import net.sf.javaprinciples.model.shared.StringUtilsShared;

public class ModelPlace extends Place
{
    private String useCase;
    private String model;
    private String content;

	public ModelPlace(String useCase, String model)
	{
        this.useCase = useCase;
		this.model = model;
	}

    public ModelPlace(String useCase, String model, String content)
    {
        this.useCase = useCase;
        this.model = model;
        this.content = content;
    }

    public String getUseCase()
    {
        return useCase;
    }

	public String getModel()
	{
		return model;
	}

    public String getContent()
    {
        return content;
    }

    public boolean equals(Object other)
    {
        if (other == this)
        {
            return true;
        }
        if (other == null || !(other instanceof  ModelPlace))
        {
            return false;
        }
        ModelPlace place = (ModelPlace)other;
        if (!StringUtilsShared.stringEquals(content, place.content))
        {
            return false;
        }
        if (!StringUtilsShared.stringEquals(model, place.model))
        {
            return false;
        }
        if (!StringUtilsShared.stringEquals(useCase, place.useCase))
        {
            return false;
        }
        return true;
    }
	public static class Tokenizer implements PlaceTokenizer<ModelPlace>
	{
        private static String SEP = "-";

        @Override
        public String getToken(ModelPlace place)
        {
            if (place.content == null)
            {
                return place.useCase + SEP + place.model;
            }
            else
            {
                return place.useCase + SEP + place.model + SEP + place.content;
            }
        }

        @Override
        public ModelPlace getPlace(String token)
        {
            if (token != null)
            {
                String[] tokens = token.split(SEP);
                switch (tokens.length)
                {
                case 3:
                   return new ModelPlace(tokens[0], tokens[1], tokens[2]);
                case 2:
                   return new ModelPlace(tokens[0], tokens[1]);
                default:
                    return null;
                }
            }
            return null;
        }
    }
}
