package net.sf.javaprinciples.presentation.activity.model;

import net.sf.javaprinciples.model.metadata.ViewType;
import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.view.model.ModelView;

import java.util.Map;

public class ModelViewFactoryImpl implements ModelViewFactory
{
    Map<ViewType, ViewBuilder> supportedViews;

    public ModelViewFactoryImpl(Map<ViewType, ViewBuilder> supportedViews)
    {
        this.supportedViews = supportedViews;
    }

    @Override
    public ModelView createViewForUsecase(ViewType viewType, ClientContext clientContext)
    {
        ModelView modelView = null;
        ViewBuilder builder = supportedViews.get(viewType);
        if (builder != null)
        {
            modelView = builder.build(clientContext);
        }
        return modelView;
    }
}
