package net.sf.javaprinciples.presentation.control;

import net.sf.javaprinciples.graph.GraphReader;
import net.sf.javaprinciples.graph.GraphWriter;

/**
 * A Control is the C in MVC for an element of data.
 *
 * The control is responsible for creating a view that represent the data element.
 * One control instance will only create one view.
 *
 * The view is expressed in terms of gwt Widget and is created once for the life of the
 * control.
 *
 * @author Warwick Slade
 */
public interface Control
{
    public boolean isVisible();
    public void setVisible(boolean visible);

    public boolean isEnabled();
    public void setEnabled(boolean enabled);

    public void bind(GraphReader reader);
    public void unbind(GraphWriter writer);
}
