package net.sf.javaprinciples.presentation.control;

import java.util.List;

/**
 * A holder of multiple controls.
 *
 * @author Warwick Slade
 */
public interface ControlContainer extends Control
{
    /**
     * 1. Search for an exact match in the current container
     * 2. Search for ends with match
     * 3. Search the parent container
     * @param name
     * @return
     */
    public Control findControlByName(String name);

    public List<Control> getControls();
}
