package net.sf.javaprinciples.presentation.event;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.web.bindery.event.shared.EventBus;

/**
 * A common base for AJAX calls
 *
 * @author Warwick Slade
 */
public class AbstractAdapter
{
    private static boolean broken;
    protected EventBus eventBus;

    protected AbstractAdapter(EventBus eventBus)
    {
        this.eventBus = eventBus;
    }

    protected void handleUnknown(Response response)
    {
        handleUnauthorised(response);
//        if (broken)
//        {
//            return;
//        }
//
//        broken = true;
//
//        String statusText = response.getStatusText();
//        if (StringUtilsShared.isBlank(statusText))
//        {
//            if (response.getStatusCode() == 0)
//            {
//                statusText = "Our system is currently unavailable, please refresh your browser in a few minutes.";
//            }
//            else
//            {
//                statusText = "Code:" + Integer.toString(response.getStatusCode());
//            }
//        }
//        RootPanel.get("loading").setVisible(false);
//        MessageBox.dialogBox("It was not possible to receive content from our Server.", statusText);
    }

    protected void handleUnauthorised(Response response)
    {
        RootPanel.get("loading").setVisible(false);
        if (broken)
        {
            return;
        }
        broken = true;

        // We need to remove the server address before we can use the header
        // Or stop using apache

//        String loginUrl = response.getHeader("login");
//        if (loginUrl != null)
//        {
            String redirectUrl = GWT.getHostPageBaseURL() + "Login.html?login-reauth";
            Window.Location.replace(redirectUrl);
            return;
//        }
//        GWT.log("Unauthorised Response");
//        RootPanel.get("loading").setVisible(false);
//        MessageBox.dialogBox("Invalid Operation", "Please refresh your browser.");
    }

    @Deprecated
    protected boolean redirectHack(String text)
    {
        if (text != null && text.contains("<!-- ##Login page hack## -->"))
        {
            String redirectUrl = GWT.getHostPageBaseURL() + "Login.html?login-reauth";
            Window.Location.replace(redirectUrl);
            return true;
        }
        return false;
    }


}
