package net.sf.javaprinciples.presentation.filter;

import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.TextBox;

public class TextFilter implements KeyDownHandler 
{
	private TextBox input;
	private CharacterFilter filter;
	
	public TextFilter(TextBox input, CharacterFilter filter)
	{
		this.input = input;
		this.filter = filter;
	}
	
	@Override
	public void onKeyDown(KeyDownEvent event) 
	{
		int key = event.getNativeKeyCode();
		
		if (acceptKeyCodes(key))
		{
			return;
		}
		if (acceptKey(key))
		{
			return;
		}
		input.cancelKey();
	}
	
	protected boolean acceptKeyCodes(int key)
	{
		switch (key)
		{
		case KeyCodes.KEY_BACKSPACE:
		case KeyCodes.KEY_DELETE:
		case KeyCodes.KEY_TAB:
		case KeyCodes.KEY_LEFT:
		case KeyCodes.KEY_RIGHT:
		case KeyCodes.KEY_HOME:
		case KeyCodes.KEY_END:
				return true;
		}
		return false;
	}
	
	protected boolean acceptKey(int key)
	{
		if (key >= 96 && key <= 105)
		{
			key -= 48;
		}
		return filter.accept(key);
	}
}
